/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.layout;

import de.bsvrz.ars.ars.persistence.layout.AbortWalkException;
import de.bsvrz.ars.ars.persistence.layout.DataIdentificationListener;
import de.bsvrz.ars.ars.persistence.layout.PathType;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Set;

public class DirectoryLayoutWalk {
    private DirectoryLayoutWalk() {
    }

    public static void walk(final PersistenceDirectoryLayoutInstance layoutInstance, final DataIdentificationListener listener) {
        final Path basePath = layoutInstance.basePath();
        PersistenceDirectoryLayout layout = layoutInstance.layout();
        final ArrayList pathStack = new ArrayList();
        try {
            FileVisitor<Path> visitor = new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    try {
                        if (dir.equals(basePath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        pathStack.add(dir.getFileName().toString());
                        PathType type = layoutInstance.getPathType(pathStack);
                        switch (type) {
                            case PartialIdPath: {
                                return FileVisitResult.CONTINUE;
                            }
                            case CompleteIdPath: {
                                listener.foundDataIdentification(layoutInstance.getPath(pathStack), dir);
                                this.removeLast();
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            case ForeignPath: {
                                if (!dir.equals(basePath.resolve("backup"))) {
                                    listener.foundForeignDirectory(dir);
                                }
                                this.removeLast();
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        }
                        throw new AssertionError();
                    }
                    catch (AbortWalkException e) {
                        return FileVisitResult.TERMINATE;
                    }
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        if (file.equals(basePath.resolve("_isActive.flag"))) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (file.equals(basePath.resolve(".isOpen.flag"))) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (file.equals(basePath.resolve("_startUpInfo.property"))) {
                            return FileVisitResult.CONTINUE;
                        }
                        listener.foundForeignFile(file);
                        return FileVisitResult.CONTINUE;
                    }
                    catch (AbortWalkException e) {
                        return FileVisitResult.TERMINATE;
                    }
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    try {
                        listener.ioException(file, exc);
                        return FileVisitResult.CONTINUE;
                    }
                    catch (AbortWalkException e) {
                        return FileVisitResult.TERMINATE;
                    }
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    this.removeLast();
                    return FileVisitResult.CONTINUE;
                }

                private void removeLast() {
                    if (!pathStack.isEmpty()) {
                        pathStack.remove(pathStack.size() - 1);
                    }
                }
            };
            int maxDepth = layout.getMaxDepth() == Integer.MAX_VALUE ? Integer.MAX_VALUE : layout.getMaxDepth() + 1;
            Files.walkFileTree(basePath, Set.of(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            try {
                listener.ioException(basePath, e);
            }
            catch (AbortWalkException abortWalkException) {
                // empty catch block
            }
        }
    }
}

