/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.layout;

import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.layout.PathType;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import java.nio.file.Path;
import java.util.List;

public class ShortPersistenceDirectoryLayout
implements PersistenceDirectoryLayout {
    public static final ShortPersistenceDirectoryLayout Instance = new ShortPersistenceDirectoryLayout();

    private ShortPersistenceDirectoryLayout() {
    }

    @Override
    public Path getPath(Path basePath, long objId, long atgId, long aspId) {
        return basePath.resolve(ShortPersistenceDirectoryLayout.encode(atgId)).resolve(ShortPersistenceDirectoryLayout.encode(aspId)).resolve(ShortPersistenceDirectoryLayout.encode(objId));
    }

    @Override
    public IdDataIdentification getDataIdentificationFromPath(List<String> path, int simulationVariant) {
        String objComponent = path.get(2);
        String aspComponent = path.get(1);
        String atgComponent = path.get(0);
        try {
            return new IdDataIdentification(ShortPersistenceDirectoryLayout.decode(objComponent), ShortPersistenceDirectoryLayout.decode(atgComponent), ShortPersistenceDirectoryLayout.decode(aspComponent), simulationVariant);
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    public static String encode(long id) {
        if (id == -1L) {
            throw new UnsupportedOperationException("Ung\u00fcltige Objekt-ID: -1");
        }
        int coding = (int)(id >>> 48);
        long runningNumber = id & 0xFFFFFFFFFFFFL;
        return coding + "-" + Long.toString(runningNumber, 36);
    }

    public static long decode(String string) throws PersistenceException {
        long result = ShortPersistenceDirectoryLayout.decodeFast(string);
        if (result == -1L) {
            throw new PersistenceException("Ung\u00fcltiger Pfad-Bestandteil: " + string);
        }
        return result;
    }

    public static long decodeFast(String string) {
        try {
            int divider = string.indexOf(45);
            if (divider == -1) {
                return -1L;
            }
            String kvPrefix = string.substring(0, divider);
            int kv = Integer.parseInt(kvPrefix);
            if (kv != (kv & 0xFFFF)) {
                return -1L;
            }
            String runningNumber = string.substring(divider + 1);
            long number = Long.parseLong(runningNumber, 36);
            if (number != (number & 0xFFFFFFFFFFFFL)) {
                return -1L;
            }
            return (long)kv << 48 | number;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public int getMaxDepth() {
        return 3;
    }

    @Override
    public PathType identifyPath(List<String> pathStack) {
        if (pathStack.size() > 3) {
            return PathType.ForeignPath;
        }
        for (String s : pathStack) {
            if (ShortPersistenceDirectoryLayout.decodeFast(s) != -1L) continue;
            return PathType.ForeignPath;
        }
        return pathStack.size() == 3 ? PathType.CompleteIdPath : PathType.PartialIdPath;
    }

    public static PersistenceDirectoryLayoutInstance instance(Path basePath, int simulationVariant) {
        return Instance.createInstance(basePath, simulationVariant);
    }
}

