/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.walk;

import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.walk.ContainerAction;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StandardContainerWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import java.time.Duration;
import java.util.Collection;

public interface ContainerWalk {
    public static ContainerWalk allContainers(PersistenceDirectory persistenceDirectory, PersistenceManager persistenceManager) {
        return new StandardContainerWalk(persistenceManager, DataIdentificationDirWalk.allDirectories(persistenceDirectory), persistenceDirectory);
    }

    public static ContainerWalk fromArchiveDataSpecification(PersistenceDirectory persistenceDirectory, Collection<? extends ArchiveDataSpecification> archiveDataSpecifications, PersistenceManager persistenceManager) {
        return new StandardContainerWalk(persistenceManager, DataIdentificationDirWalk.create(persistenceDirectory, archiveDataSpecifications), persistenceDirectory);
    }

    public Duration getStatusInterval();

    public void setStatusInterval(Duration var1);

    public StatusPrinter getStatusPrinter();

    public void setStatusPrinter(StatusPrinter var1);

    public void execute(String var1, int var2, ContainerAction var3) throws PersistenceException;

    public void terminate();
}

