/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.walk.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import de.bsvrz.ars.ars.persistence.DataIdentificationDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.layout.AbortWalkException;
import de.bsvrz.ars.ars.persistence.layout.DataIdentificationListener;
import de.bsvrz.ars.ars.persistence.layout.DirectoryLayoutWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.CountEstimator;
import de.bsvrz.ars.ars.persistence.walk.internal.DataIdentificationDirGetter;
import de.bsvrz.ars.ars.persistence.walk.internal.DataIdentificationDirListener;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public class DataIdentificationDirGetters {
    private DataIdentificationDirGetters() {
    }

    public static DataIdentificationDirGetter selectedContainerDirs(PersistenceDirectory persistenceDirectory, Collection<? extends ArchiveDataSpecification> ads) {
        LinkedHashMultimap tmpMap = LinkedHashMultimap.create();
        for (ArchiveDataSpecification archiveDataSpecification : ads) {
            tmpMap.put((Object)new IdDataIdentification(archiveDataSpecification), (Object)archiveDataSpecification);
        }
        return DataIdentificationDirGetter.create(arg_0 -> DataIdentificationDirGetters.lambda$selectedContainerDirs$0((Multimap)tmpMap, persistenceDirectory, arg_0), CountEstimator.fixed(tmpMap.size()));
    }

    public static DataIdentificationDirGetter selectedDataIdentifications(PersistenceDirectory persistenceDirectory, Collection<? extends IdDataIdentification> dataIdentifications) {
        return DataIdentificationDirGetter.create(listener -> {
            try {
                for (IdDataIdentification dataIdentification : dataIdentifications) {
                    listener.foundDataIdentification(new DataIdentificationDir(persistenceDirectory, dataIdentification));
                }
            }
            catch (AbortWalkException abortWalkException) {
                // empty catch block
            }
        }, CountEstimator.fixed(dataIdentifications.size()));
    }

    public static DataIdentificationDirGetter all(PersistenceDirectory persistenceDirectory) {
        return DataIdentificationDirGetter.create(listener -> DirectoryLayoutWalk.walk(persistenceDirectory.getLayoutInstance(), new DataIdentificationListener(){
            final /* synthetic */ DataIdentificationDirListener val$listener;
            final /* synthetic */ PersistenceDirectory val$persistenceDirectory;
            {
                this.val$listener = dataIdentificationDirListener;
                this.val$persistenceDirectory = persistenceDirectory;
            }

            @Override
            public void foundDataIdentification(IdDataIdentification dataIdentification, Path dir) throws AbortWalkException {
                this.val$listener.foundDataIdentification(new DataIdentificationDir(this.val$persistenceDirectory, dataIdentification, dir));
            }

            @Override
            public void foundForeignDirectory(Path dir) {
            }

            @Override
            public void foundForeignFile(Path file) {
            }

            @Override
            public void ioException(Path file, IOException exception) {
            }
        }), persistenceDirectory);
    }

    public static DataIdentificationDirGetter allWithDelegate(final PersistenceDirectory persistenceDirectory, final DataIdentificationListener delegate) {
        return DataIdentificationDirGetter.create(listener -> DirectoryLayoutWalk.walk(persistenceDirectory.getLayoutInstance(), new DataIdentificationListener(){
            final /* synthetic */ DataIdentificationDirListener val$listener;
            {
                this.val$listener = dataIdentificationDirListener;
            }

            @Override
            public void foundDataIdentification(IdDataIdentification dataIdentification, Path dir) throws AbortWalkException {
                delegate.foundDataIdentification(dataIdentification, dir);
                DataIdentificationDir dataIdentificationDir = new DataIdentificationDir(persistenceDirectory, dataIdentification, dir);
                this.val$listener.foundDataIdentification(dataIdentificationDir);
            }

            @Override
            public void foundForeignDirectory(Path dir) throws AbortWalkException {
                delegate.foundForeignDirectory(dir);
            }

            @Override
            public void foundForeignFile(Path file) throws AbortWalkException {
                delegate.foundForeignFile(file);
            }

            @Override
            public void ioException(Path file, IOException exception) throws AbortWalkException {
                delegate.ioException(file, exception);
            }
        }), persistenceDirectory);
    }

    private static /* synthetic */ void lambda$selectedContainerDirs$0(Multimap tmpMap, PersistenceDirectory persistenceDirectory, DataIdentificationDirListener listener) {
        try {
            for (Map.Entry entry : tmpMap.asMap().entrySet()) {
                listener.foundDataIdentification(new DataIdentificationDir(persistenceDirectory, (IdDataIdentification)entry.getKey(), (Collection)entry.getValue()));
            }
        }
        catch (AbortWalkException abortWalkException) {
            // empty catch block
        }
    }
}

