/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.walk.internal;

import de.bsvrz.ars.ars.mgmt.tasks.base.TaskProgressInterface;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.layout.AbortWalkException;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirAction;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.DataIdentificationDirGetter;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class StandardDataidentificationDirWalk
implements DataIdentificationDirWalk {
    private static final Debug _debug = Debug.getLogger();
    private final DataIdentificationDirGetter _contGetter;
    private Exception _exception;
    private ThreadPoolExecutor _executor;
    private final AtomicLong _visitedContainerFiles = new AtomicLong();
    private final AtomicLong _visitedContainerDirs = new AtomicLong();
    private final AtomicLong _indexedContainerDirs = new AtomicLong();
    private Duration _statusInterval = Duration.ofMinutes(1L);
    private Instant _lastStatus;
    private StatusPrinter _statusPrinter = new StatusPrinter();
    private Instant _start;
    private volatile boolean _terminateImmediately;
    private TaskProgressInterface _publisherTask;

    public StandardDataidentificationDirWalk(DataIdentificationDirGetter contGetter) {
        this._contGetter = contGetter;
    }

    @Override
    public Duration getStatusInterval() {
        return this._statusInterval;
    }

    @Override
    public void setStatusInterval(Duration statusInterval) {
        this._statusInterval = statusInterval;
    }

    @Override
    public StatusPrinter getStatusPrinter() {
        return this._statusPrinter;
    }

    @Override
    public void setStatusPrinter(StatusPrinter statusPrinter) {
        this._statusPrinter = statusPrinter;
    }

    @Override
    public TaskProgressInterface getPublisherTask() {
        return this._publisherTask;
    }

    @Override
    public void setPublisherTask(TaskProgressInterface publisherTask) {
        this._publisherTask = publisherTask;
    }

    @Override
    public void execute(final String actionName, int numThreads, DataIdentificationDirAction action) throws PersistenceException {
        if (this._executor != null) {
            throw new IllegalStateException("Bereits gestartet");
        }
        final long id = Thread.currentThread().getId();
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>(512, Comparator.comparing(StandardDataidentificationDirWalk::getRandomHashCode));
        this._executor = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.SECONDS, queue, new ThreadFactory(){
            private final AtomicInteger _counter = new AtomicInteger(0);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "ContainerDirWalk-" + id + "-" + actionName + "-" + this._counter.getAndIncrement());
            }
        });
        if (this._statusPrinter != null) {
            _debug.info("Starte " + actionName);
        }
        this._start = this._lastStatus = Instant.now();
        Thread indexThread = this.getIndexerThread(actionName, action, id);
        indexThread.start();
        try {
            indexThread.join();
            this._executor.shutdown();
            this._contGetter.setActualCount(this._indexedContainerDirs.get());
            _debug.fine("ContainerDirWalk-" + id + "-" + actionName + ": Verzeichnisdurchlauf beendet.");
            while (!this._executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                _debug.fine("ContainerDirWalk-" + id + "-" + actionName + ": Warte auf Beenden des Threadpools...");
                this.maybePrintStatus(actionName, true);
            }
            if (this._statusPrinter != null) {
                if (this._exception == null) {
                    _debug.info(this._statusPrinter.getSuccessMessage(actionName, Duration.between(this._start, Instant.now()), this._visitedContainerDirs.get(), this._visitedContainerFiles.get()));
                } else {
                    _debug.info(this._statusPrinter.getErrorMessage(actionName, Duration.between(this._start, Instant.now()), this._visitedContainerDirs.get(), this._visitedContainerFiles.get()));
                }
            }
        }
        catch (InterruptedException e) {
            throw new PersistenceException(e);
        }
        if (this._exception != null) {
            throw new PersistenceException(this._exception);
        }
    }

    @NotNull
    private Thread getIndexerThread(String actionName, DataIdentificationDirAction action, long id) {
        Runnable indexRunner = () -> this._contGetter.run(dataIdentificationDir -> {
            if (this._terminateImmediately) {
                throw new AbortWalkException();
            }
            this.maybePrintStatus(actionName, false);
            this._indexedContainerDirs.incrementAndGet();
            Runnable didTask = () -> {
                if (this._terminateImmediately) {
                    return;
                }
                try {
                    action.run(dataIdentificationDir, this);
                    this._visitedContainerDirs.incrementAndGet();
                }
                catch (AbortWalkException e) {
                    this._terminateImmediately = true;
                }
                catch (Exception e) {
                    _debug.warning("Fehler beim Ausf\u00fchren der Aktion", (Throwable)e);
                    this.setException(e);
                    this._executor.shutdown();
                }
            };
            try {
                this._executor.execute(didTask);
            }
            catch (RejectedExecutionException e) {
                try {
                    this._executor.getQueue().put(didTask);
                }
                catch (InterruptedException ex) {
                    this._executor.shutdownNow();
                    this._exception = ex;
                }
            }
        });
        return new Thread(indexRunner, "ContainerDirWalk-" + id + "-" + actionName + "-index");
    }

    private static int getRandomHashCode(Runnable runnable) {
        int h = runnable.hashCode();
        return (h ^ h << 16 ^ h >> 8) & 0xFFFF;
    }

    private void maybePrintStatus(String actionName, boolean indexFinished) {
        StatusPrinter.ApproximationType approximationType;
        Instant now = Instant.now();
        long upperBound = this._indexedContainerDirs.get();
        if (indexFinished) {
            approximationType = StatusPrinter.ApproximationType.Exact;
        } else {
            long estimate = this._contGetter.estimateCount();
            if (estimate > upperBound) {
                approximationType = StatusPrinter.ApproximationType.Approximation;
                upperBound = estimate;
            } else {
                approximationType = StatusPrinter.ApproximationType.Minimum;
            }
        }
        if (this._statusPrinter != null && this._lastStatus.plus(this._statusInterval).isBefore(now)) {
            _debug.info(this._statusPrinter.getStatusMessage(actionName, Duration.between(this._start, now), approximationType, upperBound, this._visitedContainerDirs.get(), this._visitedContainerFiles.get()));
            this._lastStatus = now;
        }
        if (this._publisherTask != null) {
            String estimateWord = switch (approximationType) {
                default -> throw new MatchException(null, null);
                case StatusPrinter.ApproximationType.Minimum -> "mindestens ";
                case StatusPrinter.ApproximationType.Approximation -> "ungef\u00e4hr ";
                case StatusPrinter.ApproximationType.Exact -> "";
            };
            this._publisherTask.setTaskProgress(actionName + ": %1$d von " + estimateWord + "%2$d Datenidentifikationen bearbeitet.", this._visitedContainerDirs.get(), upperBound, -1L);
        }
    }

    @Override
    public void terminate() {
        if (this._executor != null) {
            this._executor.shutdown();
        }
        this._terminateImmediately = true;
    }

    private void setException(Exception exception) {
        this._terminateImmediately = true;
        if (this._exception == null) {
            this._exception = exception;
        } else {
            this._exception.addSuppressed(exception);
        }
    }

    @Override
    public void increaseContCount(int increment) {
        this._visitedContainerFiles.addAndGet(increment);
    }
}

