/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageState;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import java.util.Objects;

public record ArchiveOnlineData(SerializableDataset dataset, IdDataIdentification dataIdentification, boolean delayed) implements ArchiveJob
{
    public static final String MSG_PID_DATAINDEX_ANOMALY = "Datenindex nicht monoton";
    private static final Debug _debug = Debug.getLogger();

    @Override
    public void accept(ArchiveTask archiveTask) {
        this.archiveData(archiveTask, true);
    }

    private void archiveData(ArchiveTask archiveTask, boolean allowDataGap) {
        try {
            boolean append;
            boolean insertGapDS;
            long archTime = this.dataset.archiveTime();
            long dataTime = this.dataset.dataTime();
            long dataIdx = this.dataset.dataIndex();
            ArchiveDataKind adk = this.delayed ? ArchiveDataKind.ONLINE_DELAYED : ArchiveDataKind.ONLINE;
            DataIdentNode din = archiveTask.getDidTree().get(this.dataIdentification);
            IdContainerFileDir idContainerFileDirOnline = this.dataIdentification.resolve(ArchiveDataKind.ONLINE);
            IdContainerFileDir idContainerFileDirDelayed = this.dataIdentification.resolve(ArchiveDataKind.ONLINE_DELAYED);
            PersistenceManager persistenceManager = archiveTask.getPersistenceManager();
            ActivePersistenceDirectory persistenceDirectory = persistenceManager.updateAndGetActivePersistenceDirectory(archTime, this.dataIdentification.getSimVariant());
            StandardOpenContainerData acd = persistenceDirectory.getOpenContainerData(idContainerFileDirOnline);
            StandardOpenContainerData ncd = persistenceDirectory.getOpenContainerData(idContainerFileDirDelayed);
            ArchiveTask.LastContainerData lastContainerData = archiveTask.initLastContainerData(acd, ncd, this.dataIdentification);
            if (this.handleIndexBackstep(persistenceManager, lastContainerData, dataIdx, din, adk, this.dataset, archTime)) {
                return;
            }
            boolean bl = insertGapDS = allowDataGap && ArchiveOnlineData.shouldInsertGap(archiveTask, din, lastContainerData, dataIdx, idContainerFileDirOnline);
            if (insertGapDS) {
                long unsubscriptionTime;
                if (!adk.equals((Object)ArchiveDataKind.ONLINE)) {
                    adk = ArchiveDataKind.ONLINE;
                }
                dataIdx = Util.dIdxSetArSBit((long)lastContainerData.lastDataIdx());
                dataTime = din.isFirstDataAfterSubscription(adk) ? ((unsubscriptionTime = din.getUnsubscriptionTime()) == -1L ? lastContainerData.lastDataTime() : unsubscriptionTime) : ArchiveTask.getLastArchiveTime();
                SerializableDataset gap = SerializableDataset.createGap(archTime, dataIdx, dataTime);
                append = archiveTask.getSerializationHelper().writeData(gap, persistenceDirectory, idContainerFileDirOnline);
            } else {
                append = archiveTask.getSerializationHelper().writeData(this.dataset, persistenceDirectory, this.dataIdentification.resolve(adk));
            }
            if (!append) {
                archiveTask.getFailCounterOnline().incrementAndGet();
                return;
            }
            persistenceDirectory.markAsDirty(this.dataIdentification.resolve(adk));
            din.setFirstDataAfterSubscription(adk, false);
            boolean isNoSource = this.dataset.dataState() == DataState.NO_SOURCE;
            din.setLastOAWasNoSource(adk.equals((Object)ArchiveDataKind.ONLINE) && isNoSource);
            if (isNoSource) {
                if (din.getUnsubscriptionTime() == -1L) {
                    din.setUnsubscriptionTime(dataTime);
                }
                din.setValidData(false);
            } else {
                din.setUnsubscriptionTime(-1L);
                din.setValidData(true);
            }
            if (!insertGapDS) {
                DataModel dataModel;
                archiveTask.getSuccessCounterOnline().incrementAndGet();
                if (this.dataset.hasData() && (dataModel = archiveTask.getArchMgr().getDataModel()) != null) {
                    try {
                        archiveTask.sendAck(this.dataset.asResultData(dataModel, this.dataIdentification, this.delayed), din);
                    }
                    catch (Exception e) {
                        _debug.error("Fehler beim Quittieren eines Datensatzes: " + e.getMessage() + Debug.NEWLINE + String.valueOf(this.dataset), (Throwable)e);
                    }
                }
            } else {
                this.archiveData(archiveTask, false);
            }
        }
        catch (Exception e) {
            archiveTask.getFailCounterOnline().incrementAndGet();
            _debug.error("Fehler beim Archivieren eines Datensatzes: " + e.getMessage() + Debug.NEWLINE + String.valueOf(this.dataset), (Throwable)e);
        }
    }

    boolean handleIndexBackstep(PersistenceManager persistenceManager, @NotNull ArchiveTask.LastContainerData lastContainerData, long dataIdx, DataIdentNode din, ArchiveDataKind adk, SerializableDataset rd, long arsTime) {
        if (dataIdx == lastContainerData.lastDataIdx() && din.isFirstDataAfterSubscription(adk)) {
            _debug.fine("Datenindex nach Neuanmeldung identisch zum letzten archivierten Datenindex. Datensatz ignoriert." + Debug.NEWLINE, (Object)rd);
            return true;
        }
        if (dataIdx <= lastContainerData.lastADataIdx()) {
            StringBuilder sb = new StringBuilder(8192);
            sb.append("Es ist ein fehlerhafter Datenindex aufgetreten. Der soeben erhaltene Datenindex ist nicht streng monoton steigend.");
            sb.append("\n\nSoeben erhalten\n===============");
            sb.append("\nDatenidentifikation: ");
            sb.append(persistenceManager.formatContainerDirectory(din.getDataIdentification().resolve(adk)));
            sb.append("\nDatenindex:          ");
            sb.append(dataIdx);
            sb.append(" [").append(Util.dIdx2Str((long)dataIdx)).append("] [").append(Util.dIdx2StrExt((long)dataIdx)).append("]");
            sb.append("\nDatenzeit:           ");
            sb.append(Util.timestrMillisFormatted((long)rd.dataTime()));
            sb.append("\nerhalten:            ");
            sb.append(Util.timestrMillisFormatted((long)arsTime));
            sb.append("\nnachgeliefert:       ");
            sb.append(Util.bTF((boolean)this.delayed));
            sb.append("\nZustand:             ");
            sb.append(rd.dataState());
            sb.append("\n\n**Beginn Daten**\n");
            sb.append(rd);
            sb.append("\n**Ende Daten**\n");
            sb.append("\nZuletzt archiviert\n==================");
            sb.append("\nArt:                 ");
            sb.append(ArchiveDataKind.ONLINE);
            if (lastContainerData.lastADataIdx() < 0L) {
                sb.append("\nDatenindex:          -");
                sb.append("\nDatenzeit:           -");
                sb.append("\nArchivzeit:          -");
            } else {
                sb.append("\nDatenindex:          ");
                sb.append(lastContainerData.lastADataIdx());
                sb.append(" [").append(Util.dIdx2Str((long)lastContainerData.lastADataIdx())).append("]");
                sb.append(" [").append(Util.dIdx2StrExt((long)lastContainerData.lastADataIdx())).append("]");
                sb.append("\nDatenzeit:           ").append(Util.timestrMillisFormatted((long)lastContainerData.lastADTime()));
                sb.append("\nArchivzeit:          ").append(Util.timestrMillisFormatted((long)lastContainerData.lastAATime()));
            }
            sb.append("\nArt:                 ");
            sb.append(ArchiveDataKind.ONLINE_DELAYED);
            if (lastContainerData.lastNDataIdx() < 0L) {
                sb.append("\nDatenindex:          -");
                sb.append("\nDatenzeit:           -");
                sb.append("\nArchivzeit:          -");
            } else {
                sb.append("\nDatenindex:          ");
                sb.append(lastContainerData.lastNDataIdx());
                sb.append(" [").append(Util.dIdx2Str((long)lastContainerData.lastNDataIdx())).append("]");
                sb.append(" [").append(Util.dIdx2StrExt((long)lastContainerData.lastNDataIdx())).append("]");
                sb.append("\nDatenzeit:           ").append(Util.timestrMillisFormatted((long)lastContainerData.lastNDTime()));
                sb.append("\nArchivzeit:          ").append(Util.timestrMillisFormatted((long)lastContainerData.lastNATime()));
            }
            sb.append("\n");
            _debug.warning("Betriebsmeldung: Datenindex nicht monoton", (Object)sb.toString());
            MessageSender.getInstance().sendMessage(MSG_PID_DATAINDEX_ANOMALY, MessageType.APPLICATION_DOMAIN, "", MessageGrade.FATAL, MessageState.MESSAGE, sb.toString());
            return true;
        }
        return false;
    }

    private static boolean shouldInsertGap(ArchiveTask archiveTask, DataIdentNode din, ArchiveTask.LastContainerData lastContainerData, long dataIdx, IdContainerFileDir containerFileDir) {
        if (archiveTask.isDataGap(dataIdx, lastContainerData)) {
            if (din.lastDataNoSourceAssigned()) {
                return !din.lastDataWasNoSource();
            }
            return !ArchiveOnlineData.scanOAContForLastNoSrc(lastContainerData.lastAContID(), archiveTask.getPersistenceManager(), containerFileDir);
        }
        return false;
    }

    static boolean scanOAContForLastNoSrc(long lastAContID, PersistenceManager persMgr, IdContainerFileDir containerFileDir) {
        if (lastAContID == -1L) {
            return false;
        }
        LockedContainerDirectory directory = persMgr.lockIndex(containerFileDir);
        try {
            boolean bl;
            ContainerDataResult data = persMgr.getLastDataSet(directory);
            boolean bl2 = bl = data != null && data.isNoSource();
            if (directory != null) {
                directory.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (directory != null) {
                    try {
                        directory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                _debug.warning("Fehler beim Scan \u00fcber den letzten Container wird ignoriert", (Throwable)e);
                return false;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArchiveOnlineData that = (ArchiveOnlineData)obj;
        return Objects.equals(this.dataset, that.dataset);
    }

    @Override
    public String toString() {
        return "ArchiveOnlineData[dataset=" + String.valueOf(this.dataset) + "]";
    }

    @Override
    public long estimateMemoryUsage() {
        return 28L + this.dataset.estimateMemoryUsage();
    }
}

