/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.tasks.RepeatingTask;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.util.TerminatedException;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.CloseConditions;
import de.bsvrz.ars.ars.persistence.writer.SerializationHelper;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.util.concurrent.atomic.AtomicLong;

public class ArchiveTask
extends RepeatingTask {
    private final AtomicLong _successCountOnline = new AtomicLong(0L);
    private final AtomicLong _successCountRequested = new AtomicLong(0L);
    private final AtomicLong _failCountOnline = new AtomicLong(0L);
    private final AtomicLong _failCountRequested = new AtomicLong(0L);
    private final AtomicLong _closeCount = new AtomicLong(0L);
    private final SignalingQueue<ArchiveJob> inputDataQueue;
    private static long lastArchiveTime;
    private static ContainerSettings containerSettings;
    private final SerializationHelper serializationHelper = new SerializationHelper(new CloseConditions(){

        @Override
        public ContainerSettings.CloseCondition getCloseCondition(long atg) {
            ContainerSettings.CloseCondition exceptionalConditions = this.getException(atg);
            if (exceptionalConditions != null) {
                return exceptionalConditions;
            }
            return ArchiveTask.containerSettings.stdCloseConditions;
        }

        private ContainerSettings.CloseCondition getException(long atg) {
            try {
                DataModel dataModel = ArchiveTask.this.getArchMgr().getDataModel();
                if (dataModel == null) {
                    return null;
                }
                AttributeGroup group = (AttributeGroup)dataModel.getObject(atg, AttributeGroup.class);
                if (group == null) {
                    return null;
                }
                return containerSettings.getExceptionSettings(group);
            }
            catch (Exception e) {
                _debug.warning("Attributgruppe nicht ermittelbar: " + atg, (Throwable)e);
                return null;
            }
        }
    }, this.getPersistenceManager(), true);

    public SerializationHelper getSerializationHelper() {
        return this.serializationHelper;
    }

    public static void setContainerSettings(ContainerSettings cs) {
        containerSettings = cs;
    }

    public static ContainerSettings getContainerSettings() {
        return containerSettings;
    }

    public ArchiveTask(ArchiveManager archiveMgr, SignalingQueue<ArchiveJob> inQueue) {
        super(archiveMgr);
        this.inputDataQueue = inQueue;
    }

    @Override
    public void step() throws InterruptedException {
        try {
            this.inputDataQueue.take().accept(this);
        }
        catch (TerminatedException e) {
            return;
        }
        this.taskStepDone();
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        this.inputDataQueue.terminateNow();
    }

    public long getSuccessCount() {
        return this.getSuccessCountOnline() + this.getSuccessCountRequested();
    }

    public long getFailedCount() {
        return this.getFailedCountOnline() + this.getFailedCountRequested();
    }

    public long getSuccessCountRequested() {
        return this._successCountRequested.longValue();
    }

    public long getFailedCountRequested() {
        return this._failCountRequested.longValue();
    }

    public long getSuccessCountOnline() {
        return this._successCountOnline.longValue();
    }

    public long getFailedCountOnline() {
        return this._failCountOnline.longValue();
    }

    public long getCloseContainerSuccess() {
        return this._closeCount.longValue();
    }

    public void resetDSCounter() {
        this._successCountOnline.set(0L);
        this._failCountOnline.set(0L);
        this._successCountRequested.set(0L);
        this._failCountRequested.set(0L);
        this._closeCount.set(0L);
    }

    public static void setLastArchiveTime(long atime) {
        lastArchiveTime = atime;
    }

    public static long getLastArchiveTime() {
        return lastArchiveTime;
    }

    @NotNull
    LastContainerData initLastContainerData(StandardOpenContainerData acd, StandardOpenContainerData ncd, IdDataIdentification dataIdentification) throws SynchronizationFailedException, IndexException {
        ContainerHeaders irN;
        ContainerHeaders irA;
        if (acd != null || ncd != null) {
            return new LastContainerData(acd == null ? -1L : acd.getMaxDataIdx(), ncd == null ? -1L : ncd.getMaxDataIdx(), acd == null ? -1L : acd.getMaxDataTime(), ncd == null ? -1L : ncd.getMaxDataTime(), acd == null ? -1L : acd.getMaxArcTime(), ncd == null ? -1L : ncd.getMaxArcTime(), acd == null ? -1L : acd.getContainerId());
        }
        try (SyncKey<IdDataIdentification> lock = this.getPersistenceManager().lockIndex(dataIdentification);){
            irA = this.getPersistenceManager().getLastContainerHeaders(new LockedContainerDirectory(lock, ArchiveDataKind.ONLINE));
            irN = this.getPersistenceManager().getLastContainerHeaders(new LockedContainerDirectory(lock, ArchiveDataKind.ONLINE_DELAYED));
        }
        long lastADataIdx = irA != null ? irA.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX) : -1L;
        long lastNDataIdx = irN != null ? irN.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX) : -1L;
        long lastADTime = irA != null ? irA.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX) : -1L;
        long lastNDTime = irN != null ? irN.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX) : -1L;
        long lastAATime = irA != null ? irA.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX) : -1L;
        long lastNATime = irN != null ? irN.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX) : -1L;
        long lastAContID = irA != null ? irA.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID) : -1L;
        return new LastContainerData(lastADataIdx, lastNDataIdx, lastADTime, lastNDTime, lastAATime, lastNATime, lastAContID);
    }

    boolean isDataGap(long dataIndex, LastContainerData lastContainerData) {
        if (this.getArchMgr().getInQueuesMgr().getRuntimeControl().archiveOnlyData()) {
            return false;
        }
        if (lastContainerData == null) {
            return false;
        }
        if (Util.dIdxArSBit((long)lastContainerData.lastDataIdx()) == 1) {
            return false;
        }
        if (ArchiveTask.isIndexGap(lastContainerData.lastDataIdx(), dataIndex)) {
            _debug.fine("Potentielle Datenluecke erkannt: letzter archivierter Index (O" + (lastContainerData.lastIsOnline() ? "A" : "N") + "): " + lastContainerData.lastDataIdx() + " [" + Util.dIdx2Str((long)lastContainerData.lastDataIdx()) + "] [" + Util.dIdx2StrExt((long)lastContainerData.lastDataIdx()) + "], erhaltener Datenindex" + dataIndex + " [" + Util.dIdx2Str((long)dataIndex) + "] [" + Util.dIdx2StrExt((long)dataIndex) + "]");
            return true;
        }
        return false;
    }

    public static boolean isIndexGap(long lastDataIdx, long nextDataIdx) {
        return Util.dIdxNoModBits((long)nextDataIdx) > Util.dIdxNoModBits((long)lastDataIdx) + 1L;
    }

    protected void sendAck(ResultData rd, DataIdentNode din) {
        if (din.isArSParameterized() && din.arSParamIsArchivieren() && din.arSParamIsQuittierenValid()) {
            long qAspId = din.arSParamGetQuittieren();
            try {
                this.getArchMgr().getInQueuesMgr().getDataAckSender().sendAck(rd, qAspId);
                _debug.finest("Quittung unter Aspekt '" + qAspId + "' gesendet fuer", (Object)Util.rd2Str((ResultData)rd));
            }
            catch (DataNotSubscribedException | SendSubscriptionNotConfirmed e) {
                _debug.warning("Senden der Quittung unter Aspekt '" + qAspId + "' fehlgeschlagen: " + e.getMessage() + Debug.NEWLINE + Util.rd2Str((ResultData)rd));
            }
        }
    }

    public AtomicLong getFailCounterOnline() {
        return this._failCountOnline;
    }

    public AtomicLong getFailCounterRequested() {
        return this._failCountRequested;
    }

    public AtomicLong getCloseCounter() {
        return this._closeCount;
    }

    public AtomicLong getSuccessCounterOnline() {
        return this._successCountOnline;
    }

    public AtomicLong getSuccessCounterRequested() {
        return this._successCountRequested;
    }

    static {
        ContainerSettings settings = new ContainerSettings();
        settings.stdCloseConditions.maxContAnzDS = 5000;
        settings.stdCloseConditions.maxContSize = 20000000;
        settings.stdCloseConditions.maxContTime = 604800L;
        ArchiveTask.setContainerSettings(settings);
    }

    public record LastContainerData(long lastADataIdx, long lastNDataIdx, long lastADTime, long lastNDTime, long lastAATime, long lastNATime, long lastAContID) {
        public long lastDataIdx() {
            return Math.max(this.lastADataIdx, this.lastNDataIdx);
        }

        public long lastDataTime() {
            return Math.max(this.lastADTime, this.lastNDTime);
        }

        public boolean lastIsOnline() {
            return this.lastADataIdx > this.lastNDataIdx;
        }
    }
}

