/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.tasks.ArchiveDataSerializer;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;

public final class AsyncSerializableDataset
implements SerializableDataset {
    private final long archiveTime;
    private final long dataTime;
    private final long dataIndex;
    private final byte dataStateCode;
    private final Data originalData;
    private byte[] serializedData;
    private int uncompressedSize;

    public AsyncSerializableDataset(long archiveTime, long dataTime, long dataIndex, byte dataStateCode, Data originalData) {
        this.archiveTime = archiveTime;
        this.dataTime = dataTime;
        this.dataIndex = dataIndex;
        this.dataStateCode = dataStateCode;
        this.originalData = originalData;
    }

    @Override
    public long archiveTime() {
        return this.archiveTime;
    }

    @Override
    public long dataTime() {
        return this.dataTime;
    }

    @Override
    public long dataIndex() {
        return this.dataIndex;
    }

    @Override
    @NotNull
    public DataState dataState() {
        return DataState.getInstance((int)this.dataStateCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(byte[] data, int uncompressedSize) {
        AsyncSerializableDataset asyncSerializableDataset = this;
        synchronized (asyncSerializableDataset) {
            this.uncompressedSize = uncompressedSize;
            this.serializedData = data;
            this.notifyAll();
        }
    }

    @Override
    @NotNull
    public byte[] serializedData() {
        this.ensureCompleted();
        return this.serializedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompleted() {
        AsyncSerializableDataset asyncSerializableDataset = this;
        synchronized (asyncSerializableDataset) {
            if (this.serializedData != null) {
                return;
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.serializedData != null) {
                return;
            }
            new ArchiveDataSerializer().serializeData(this);
            assert (this.serializedData != null);
        }
    }

    @Override
    public long estimateMemoryUsage() {
        return ArchiveJob.estimateDatasetUsage(this);
    }

    @Override
    public boolean hasData() {
        return this.dataStateCode == 1;
    }

    @Override
    public Data originalData() {
        return this.originalData;
    }

    @Override
    public int uncompressedSize() {
        this.ensureCompleted();
        return this.uncompressedSize;
    }

    public String toString() {
        return "AsyncSerializableDataset[\n  Archivzeit=" + Util.timestrMillisFormatted((long)this.archiveTime()) + "\n  Datenzeit=" + Util.timestrMillisFormatted((long)this.dataTime()) + "\n  Datenindex=" + Util.dIdx2StrExt((long)this.dataIndex()) + "\n  Art=" + String.valueOf(this.dataState()) + "\n  Komprimiert=" + Util.printHex((byte[])this.serializedData()) + "\n  Speicherverbrauch=" + (this.uncompressedSize() == 0 ? this.serializedData().length : this.uncompressedSize()) + " Bytes\n]";
    }
}

