/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.tasks.SerializeTaskHelper;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.writer.AsyncSerializableDataset;
import de.bsvrz.ars.ars.persistence.writer.RegularSerializableDataset;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.Dataset;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import org.jetbrains.annotations.Contract;

public interface SerializableDataset {
    @NotNull
    @Contract(value="_, _, _ -> new")
    public static SerializableDataset createGap(long archTime, long dataIdx, long dataTime) {
        return new RegularSerializableDataset(archTime, dataTime, dataIdx, ContainerFile.POT_GAP);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static SerializableDataset create(ContainerDataResult result) {
        byte[] dataBytes = result.getData();
        if (dataBytes == null) {
            dataBytes = switch (result.getDataState().getCode()) {
                case 2 -> ContainerFile.NO_DATA;
                case 3 -> ContainerFile.NO_SOURCE;
                case 4 -> ContainerFile.NO_RIGHTS;
                default -> ContainerFile.POT_GAP;
            };
        }
        return new RegularSerializableDataset(result.getArchiveTime(), result.getDataTime(), result.getDataIndex(), dataBytes, result.getDataUncompressedSize(), result.isCompressed());
    }

    @NotNull
    private static SerializableDataset createEmpty(Dataset dataset, long archiveTime) {
        byte[] bytes = switch (dataset.getDataType().getCode()) {
            case 2 -> ContainerFile.NO_DATA;
            case 3 -> ContainerFile.NO_SOURCE;
            case 4 -> ContainerFile.NO_RIGHTS;
            default -> throw new IllegalArgumentException("Unerwarteter DataState: " + String.valueOf(dataset.getDataType()));
        };
        return new RegularSerializableDataset(archiveTime, dataset.getDataTime(), dataset.getDataIndex(), bytes);
    }

    @NotNull
    public static SerializableDataset create(Dataset dataset, long archiveTime, SerializeTaskHelper helper) {
        Data data = dataset.getData();
        if (data == null) {
            return SerializableDataset.createEmpty(dataset, archiveTime);
        }
        AsyncSerializableDataset asyncSerializableDataset = new AsyncSerializableDataset(archiveTime, dataset.getDataTime(), dataset.getDataIndex(), (byte)dataset.getDataType().getCode(), data);
        helper.complete(asyncSerializableDataset);
        return asyncSerializableDataset;
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static SerializableDataset createAsync(Dataset dataset, long archiveTime, SignalingQueue<AsyncSerializableDataset> serializeQueue) {
        Data data = dataset.getData();
        if (data == null) {
            return SerializableDataset.createEmpty(dataset, archiveTime);
        }
        AsyncSerializableDataset asyncSerializableDataset = new AsyncSerializableDataset(archiveTime, dataset.getDataTime(), dataset.getDataIndex(), (byte)dataset.getDataType().getCode(), data);
        serializeQueue.add(asyncSerializableDataset);
        return asyncSerializableDataset;
    }

    public long archiveTime();

    public long dataTime();

    public long dataIndex();

    @NotNull
    public DataState dataState();

    @NotNull
    public byte[] serializedData();

    public long estimateMemoryUsage();

    default public boolean hasData() {
        return this.dataState().equals(DataState.DATA);
    }

    @Nullable
    public Data originalData();

    default public ResultData asResultData(DataModel dataModel, IdDataIdentification did, boolean isDelayed) {
        AttributeGroup attributeGroup = (AttributeGroup)dataModel.getObject(did.getAtgId(), AttributeGroup.class);
        Aspect asp = (Aspect)dataModel.getObject(did.getAspectId(), Aspect.class);
        return new ResultData(dataModel.getObject(did.getObjectId()), new DataDescription(attributeGroup, asp, (short)did.getSimVariant()), isDelayed, this.dataIndex(), this.dataTime(), (byte)(this.dataState().getCode() - 1), this.originalData());
    }

    public int uncompressedSize();
}

