/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveDataSerializer;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.OpenContainerData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.writer.CloseConditions;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import de.bsvrz.sys.funclib.losb.util.Util;

public class SerializationHelper {
    private final ArchiveDataSerializer serializer = new ArchiveDataSerializer();
    private static final Debug _debug = Debug.getLogger();
    private final ContainerCreator containerCreator;
    private final boolean updateIndexes;
    private final CloseConditions closeConditions;

    public SerializationHelper(CloseConditions closeConditions, ContainerCreator containerCreator, boolean updateIndexes) {
        this.closeConditions = closeConditions;
        this.containerCreator = containerCreator;
        this.updateIndexes = updateIndexes;
    }

    public boolean writeData(SerializableDataset dataset, ActivePersistenceDirectory persistenceDirectory, ContainerDirectory containerDirectory) throws PersistenceException, IndexException, SynchronizationFailedException {
        int dataEntryLen = this.getSerializer().serializeData(dataset);
        return this.appendSerializedData(persistenceDirectory, containerDirectory, dataset, dataEntryLen);
    }

    public boolean appendSerializedData(ActivePersistenceDirectory persistenceDirectory, ContainerDirectory containerFileDir, SerializableDataset dataset, int dataEntryLen) throws PersistenceException, IndexException, SynchronizationFailedException {
        OpenContainerData openContainerData = this.updateIndexes ? persistenceDirectory.getOpenContainerData(containerFileDir) : persistenceDirectory.getLoadedContainerData(containerFileDir);
        long archTime = dataset.archiveTime();
        long dataIdx = dataset.dataIndex();
        long dataTime = dataset.dataTime();
        if (openContainerData instanceof StandardOpenContainerData) {
            OpenContainerData containerData = openContainerData;
            try (ContainerFileHandle _currentContainer = persistenceDirectory.accessOpenContainer(containerFileDir, ((StandardOpenContainerData)containerData).getContainerId());){
                if (!this.mustCloseContainer((StandardOpenContainerData)containerData, dataIdx, dataTime, dataEntryLen, _currentContainer, containerFileDir.archiveDataKind())) {
                    _currentContainer.appendSerializedData(this.serializer);
                    persistenceDirectory.updateMaxValues(containerFileDir, dataIdx, archTime, dataTime);
                    boolean bl = true;
                    return bl;
                }
                try (LockedContainerDirectory lockedDirectory = this.containerCreator.lockIndex(containerFileDir);){
                    ContainerFile cf = _currentContainer.getContainerFile();
                    cf.closeContainer((StandardOpenContainerData)containerData);
                    if (this.updateIndexes) {
                        persistenceDirectory.updateContainerIndex(_currentContainer, lockedDirectory);
                        persistenceDirectory.updateStandardIndexes(lockedDirectory, (StandardOpenContainerData)containerData);
                    }
                    persistenceDirectory.removeOpenContainerData(lockedDirectory);
                }
            }
        }
        return this.createNewContainer(persistenceDirectory, containerFileDir, dataset, dataEntryLen);
    }

    public boolean createNewContainer(ActivePersistenceDirectory persistenceDirectory, ContainerDirectory containerDirectory, SerializableDataset dataset, int dataEntryLen) throws PersistenceException, IndexException, SynchronizationFailedException {
        long archTime = dataset.archiveTime();
        long dataIdx = dataset.dataIndex();
        long dataTime = dataset.dataTime();
        if (this.tooLargeForNewContainer(dataEntryLen, containerDirectory.getAtgId())) {
            return false;
        }
        long openContID = this.containerCreator.nextContainerID();
        try (LockedContainerDirectory lockedDirectory = this.containerCreator.lockIndex(containerDirectory);
             ContainerFileHandle currentContainer = persistenceDirectory.accessOpenContainer(lockedDirectory, openContID);){
            currentContainer.createContainer();
            currentContainer.appendSerializedData(this.serializer);
            if (this.updateIndexes) {
                persistenceDirectory.updateContainerIndex(currentContainer, lockedDirectory);
                persistenceDirectory.addIndexEntries(lockedDirectory, dataIdx, archTime, dataTime, openContID);
            } else {
                StandardOpenContainerData openContainerData = new StandardOpenContainerData(1L, archTime, archTime, dataTime, dataTime, dataIdx, dataIdx, openContID);
                persistenceDirectory.setOpenContainerData(lockedDirectory, openContainerData);
            }
        }
        return true;
    }

    private boolean mustCloseContainer(StandardOpenContainerData openContainerData, long dataIdx, long dataTime, long dataEntryLen, ContainerFileHandle currentContainer, ArchiveDataKind adk) throws PersistenceException {
        long previousDataTime;
        long previousDataIndex = openContainerData.getMaxDataIdx();
        if (dataIdx < previousDataIndex) {
            _debug.fine("Datenindex-Ruecksprung in aktuellen Daten fuer " + String.valueOf(currentContainer) + ": " + Util.timestrMillisFormatted((long)dataTime) + " < " + Util.timestrMillisFormatted((long)openContainerData.getMaxDataTime()));
            return true;
        }
        long l = previousDataTime = adk.isDelayed() ? openContainerData.getMaxDataTime() : openContainerData.getMinDataTime();
        if (dataTime < previousDataTime) {
            _debug.fine("Datenzeit-Ruecksprung in aktuellen Daten fuer " + String.valueOf(currentContainer) + ": " + Util.timestrMillisFormatted((long)dataTime) + " < " + Util.timestrMillisFormatted((long)previousDataTime));
            return true;
        }
        ContainerSettings.CloseCondition closeCond = this.closeConditions.getCloseCondition(currentContainer.getLocation().getAtgId());
        return this.checkCloseCondition(closeCond, openContainerData, dataTime, dataEntryLen, currentContainer);
    }

    private boolean tooLargeForNewContainer(int dataEntryLen, long atgId) {
        long totalLen = ContainerFile.getHeaderLen() + dataEntryLen;
        ContainerSettings.CloseCondition closeCond = this.closeConditions.getCloseCondition(atgId);
        if (totalLen > (long)closeCond.maxContSize) {
            _debug.warning("Datensatz (" + dataEntryLen + " Bytes) + Header (" + ContainerFile.getHeaderLen() + " Bytes) ist gr\u00f6\u00dfer als die maximale Containerl\u00e4nge (" + closeCond.maxContSize + " Bytes) und wurde nicht archiviert");
            return true;
        }
        return false;
    }

    private boolean checkCloseCondition(ContainerSettings.CloseCondition closeCond, StandardOpenContainerData openContainerData, long dataTime, long dataEntryLen, ContainerFileHandle currentContainer) throws PersistenceException {
        return openContainerData.getNumContainerEntries() >= (long)closeCond.maxContAnzDS || dataTime - openContainerData.getMinDataTime() >= closeCond.maxContTime * 1000L || currentContainer.getContainerSize() + dataEntryLen > (long)closeCond.maxContSize;
    }

    public ArchiveDataSerializer getSerializer() {
        return this.serializer;
    }
}

