/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.repair;

import com.google.common.base.Strings;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DeletedContainerFile;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandaloneContainerFileHandle;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndexImpl;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.backend.management.AbstractIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.layout.DataKinds;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPInputStream;

public final class ArchiveFileViewer {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Keine Dateien angegeben");
            return;
        }
        for (String argument : args) {
            File file = new File(argument);
            if (!file.exists()) {
                System.err.println(String.valueOf(file) + ": Datei nicht gefunden");
                continue;
            }
            ArchiveFileViewer.analyzeFileOrDirectory(file);
        }
    }

    public static void analyzeFileOrDirectory(File file) {
        if (file.isFile()) {
            try {
                ArchiveFileViewer.analyzeFile(file);
            }
            catch (IOException e) {
                System.err.print(String.valueOf(file) + ": Fehler beim Verarbeiten der Datei");
                e.printStackTrace(System.err);
            }
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                System.err.println(String.valueOf(file) + ": Verzeichnis ist leer");
                return;
            }
            Arrays.sort(files, Comparator.comparing(File::getName));
            for (File subFile : files) {
                ArchiveFileViewer.analyzeFileOrDirectory(subFile);
            }
        } else {
            System.err.println(String.valueOf(file) + ": Wird ignoriert, keine Datei");
        }
    }

    public static void analyzeFile(File file) throws IOException {
        if (ContainerFile.CONT_FILENAME_FILTER.accept(file.getParentFile(), file.getName())) {
            try {
                StandaloneContainerFileHandle handle = new StandaloneContainerFileHandle(file.toPath());
                handle.readContainerHeader();
                ArchiveFileViewer.printFileType("Containerdatei, Position: " + String.valueOf(handle.getLocation()), file);
                ArchiveFileViewer.printContainerHeadersTableStart();
                ArchiveFileViewer.printContainerHeadersData(handle);
                System.out.println("Daten:");
                ArchiveFileViewer.printContainerDataTable(handle.iterator());
            }
            catch (SynchronizationFailedException | PersistenceException e) {
                throw new IOException(e);
            }
        } else if (file.getName().equals("_deleted.dat")) {
            ArchiveFileViewer.printFileType("Datei mit gel\u00f6schten Containern", file);
            ArchiveFileViewer.dumpDeletedContainerFile(file);
        } else if (file.getName().equals("_deleted.backup")) {
            ArchiveFileViewer.printFileType("Sicherungskopie von Datei mit gel\u00f6schten Containern", file);
            ArchiveFileViewer.dumpDeletedContainerFile(file);
        } else if (file.getName().equals("_deleted.tmp")) {
            ArchiveFileViewer.printFileType("Tempor\u00e4re Datei mit gel\u00f6schten Containern", file);
            ArchiveFileViewer.dumpDeletedContainerFile(file);
        } else if (file.getName().equals(DataTimeIndexImpl.IDX_FILENAME)) {
            ArchiveFileViewer.printFileType("Datenzeit-Index", file);
            ArchiveFileViewer.dumpIndex(() -> new DataTimeIndexImpl(1024, file.toPath()));
        } else if (file.getName().equals(DataIndexIndexImpl.IDX_FILENAME)) {
            ArchiveFileViewer.printFileType("Datenindex-Index", file);
            ArchiveFileViewer.dumpIndex(() -> new DataIndexIndexImpl(1024, file.toPath()));
        } else if (file.getName().equals(ArchiveTimeIndexImpl.IDX_FILENAME)) {
            ArchiveFileViewer.printFileType("Archivzeit-Index", file);
            ArchiveFileViewer.dumpIndex(() -> new ArchiveTimeIndexImpl(1024, file.toPath()));
        } else if (file.getName().equals(ContainerManagementIndex.IDX_FILENAME)) {
            ArchiveFileViewer.printFileType("Verwaltungsinformationen-Index", file);
            ArchiveFileViewer.dumpIndex(() -> new ContainerManagementIndex(1024, file.toPath()));
        } else if (file.getName().endsWith(".datagaps") || file.getName().startsWith("_datagaps.txt")) {
            ArchiveFileViewer.printFileType("L\u00fcckendatei zum Nachfordern", file);
            ArchiveFileViewer.dumpRawFile(file);
        } else if (file.getName().equals("_startUpInfo.property")) {
            ArchiveFileViewer.printFileType("Startup-Info", file);
            ArchiveFileViewer.dumpRawFile(file);
        } else if (file.getName().equals("_restartTime.property")) {
            ArchiveFileViewer.printFileType("Datenzeit-Neustart-Informationen", file);
            ArchiveFileViewer.dumpRestartFileTimes(file);
        } else if (file.getName().equals("_isActive.flag")) {
            ArchiveFileViewer.printFileType("Lock-File (Zugriff)", file);
        } else if (file.getName().equals(".isOpen.flag")) {
            ArchiveFileViewer.printFileType("Lock-File (Beschreibbar)", file);
        } else {
            ArchiveFileViewer.printFileType("Unbekannte Datei", file);
        }
    }

    private static void dumpRestartFileTimes(File file) throws IOException {
        System.out.println("            Objekt-ID |    Attributgruppen-ID |             Aspekt-ID |  SV | DA |          Abmelde-Zeit");
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]))));){
            int numEntries = stream.readInt();
            for (int i = 0; i < numEntries; ++i) {
                System.out.println("===================== | ===================== | ===================== | === | == | =====================");
                long time = stream.readLong();
                int numValues = stream.readInt();
                for (int f = 0; f < numValues; ++f) {
                    long objId = stream.readLong();
                    long atgId = stream.readLong();
                    long aspId = stream.readLong();
                    short sv = stream.readShort();
                    byte adkIndex = stream.readByte();
                    System.out.print(Strings.padStart((String)String.valueOf(objId), (int)21, (char)' '));
                    System.out.print(" | ");
                    System.out.print(Strings.padStart((String)String.valueOf(atgId), (int)21, (char)' '));
                    System.out.print(" | ");
                    System.out.print(Strings.padStart((String)String.valueOf(aspId), (int)21, (char)' '));
                    System.out.print(" | ");
                    System.out.print(Strings.padStart((String)String.valueOf(sv), (int)3, (char)' '));
                    System.out.print(" | ");
                    System.out.print(DataKinds.getDataKindSuffix(adkIndex));
                    System.out.print(" | ");
                    System.out.println(Strings.padStart((String)String.valueOf(time), (int)21, (char)' '));
                }
            }
        }
    }

    private static void printFileType(String fileType, File file) {
        System.out.println();
        System.out.println(file);
        System.out.println("Dateityp: " + fileType + ", " + file.length() + " Bytes");
    }

    private static void dumpRawFile(File file) throws IOException {
        Files.readAllLines(file.toPath(), StandardCharsets.US_ASCII).forEach(System.out::println);
    }

    private static <E extends Enum<E>> void dumpIndex(IndexCreator<E> indexCreator) throws IOException {
        try (AbstractIndex<E> index = indexCreator.buildIndex();){
            ArchiveFileViewer.printTable(index.query());
        }
        catch (IndexException e) {
            throw new IOException(e);
        }
    }

    public static <E extends Enum<E>> void printTable(IndexResult<E> result) {
        IndexContentDescriptor.IndexColumn column;
        int i;
        List<IndexContentDescriptor.IndexColumn> columns = result.getColumns();
        int[] columnWidths = new int[columns.size()];
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            columnWidths[i] = Math.max(column.getData().toString().length(), ArchiveFileViewer.computeWidth(column));
        }
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (i != 0) {
                System.out.print(" | ");
            }
            System.out.print(Strings.padStart((String)column.getData().toString(), (int)columnWidths[i], (char)' '));
        }
        System.out.println();
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (i != 0) {
                System.out.print(" | ");
            }
            System.out.print(Strings.padStart((String)(column.getLengthBytes() + " " + ArchiveFileViewer.formatType(column.getType())), (int)columnWidths[i], (char)' '));
        }
        System.out.println();
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                System.out.print("=|=");
            }
            System.out.print(Strings.repeat((String)"=", (int)columnWidths[i]));
        }
        System.out.println();
        for (int d = 0; d < result.size(); ++d) {
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                IndexContentDescriptor.IndexColumn column2 = columns.get(i2);
                if (i2 != 0) {
                    System.out.print(" | ");
                }
                System.out.print(Strings.padStart((String)ArchiveFileViewer.getString(result, d, column2), (int)columnWidths[i2], (char)' '));
            }
            System.out.println();
        }
    }

    private static <E extends Enum<E>> String getString(IndexResult<E> result, int d, IndexContentDescriptor.IndexColumn column) {
        if (column.getType() == ColumnType.String) {
            return result.getString(d, column.getData()).trim();
        }
        long number = result.get(d, column.getData());
        String columnName = column.getData().toString();
        if (columnName.contains("DI") || columnName.contains("DataIndex")) {
            return Util.dIdx2Str((long)number);
        }
        if (columnName.equals("anzDS") && number == 0xFFFFFFFFL) {
            return "Offen";
        }
        if (columnName.contains("Time") || columnName.contains("Z")) {
            return Instant.ofEpochMilli(number).toString();
        }
        return String.valueOf(number);
    }

    private static String getString(ContainerManagementData headers, ContainerManagementInformation column) throws PersistenceException {
        if (!column.isNumeric()) {
            return headers.getContainerHeaderParamAsString(column).trim();
        }
        long number = headers.getContainerHeaderParamAsLong(column);
        String columnName = column.toString();
        if (columnName.contains("DI") || columnName.contains("DataIndex")) {
            return Util.dIdx2Str((long)number);
        }
        if (columnName.equals("anzDS") && (int)number == -1) {
            return "Offen";
        }
        if (columnName.contains("Z")) {
            return Instant.ofEpochMilli(number).toString();
        }
        return String.valueOf(number);
    }

    private static String formatType(ColumnType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ColumnType.StrictlyIncreasing -> "SM";
            case ColumnType.Increasing -> "M";
            case ColumnType.Unordered -> "U";
            case ColumnType.Unique -> "Uq";
            case ColumnType.String -> "T";
        };
    }

    private static int computeWidth(IndexContentDescriptor.IndexColumn column) {
        if (column.getType() == ColumnType.String) {
            return column.getLengthBytes();
        }
        return ArchiveFileViewer.getStringWidthForBytes(column.getLengthBytes());
    }

    public static int computeWidth(ContainerManagementInformation column) {
        if (!column.isNumeric()) {
            return column.getValLen();
        }
        if (column.toString().contains("Z")) {
            return 24;
        }
        return ArchiveFileViewer.getStringWidthForBytes(column.getByteLength());
    }

    private static int getStringWidthForBytes(int lengthBytes) {
        return switch (lengthBytes) {
            case 8 -> 21;
            case 7 -> 17;
            case 6 -> 15;
            case 5 -> 13;
            case 4 -> 10;
            case 3 -> 8;
            case 2 -> 5;
            case 1 -> 3;
            default -> throw new IllegalArgumentException(String.valueOf(lengthBytes));
        };
    }

    private static void dumpDeletedContainerFile(File file) throws IOException {
        try {
            DeletedContainerFile deletedContainerFile = new DeletedContainerFile(file.toPath().getParent(), null);
            deletedContainerFile.read();
            ArchiveFileViewer.printContainerHeadersTableStart();
            for (Long contId : deletedContainerFile.containers()) {
                ContainerManagementData headers = deletedContainerFile.headers(contId);
                ArchiveFileViewer.printContainerHeadersData(headers);
            }
            System.out.println("Gel\u00f6schte Bereiche:");
            System.out.println("       contID |                 DImin |                 DImax");
            System.out.println("==============|=======================|======================");
            for (Long contId : deletedContainerFile.containers()) {
                List<DeletedContainerFile.IndexRange> deletedBlocks = deletedContainerFile.deletedBlocks(contId);
                assert (deletedBlocks != null);
                ArchiveFileViewer.printDeletedBlocksTable(String.valueOf(contId), deletedBlocks);
            }
        }
        catch (PersistenceException e) {
            throw new IOException(e);
        }
    }

    private static void printContainerHeadersTableStart() {
        ContainerManagementInformation column;
        int i;
        List<ContainerManagementInformation> columns = Arrays.asList(ContainerManagementInformation.values());
        int[] columnWidths = new int[columns.size()];
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            columnWidths[i] = Math.max(column.toString().length(), ArchiveFileViewer.computeWidth(column));
        }
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (i != 0) {
                System.out.print(" | ");
            }
            System.out.print(Strings.padStart((String)column.toString(), (int)columnWidths[i], (char)' '));
        }
        System.out.println();
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                System.out.print("=|=");
            }
            System.out.print(Strings.repeat((String)"=", (int)columnWidths[i]));
        }
        System.out.println();
    }

    private static void printContainerHeadersData(ContainerManagementData headers) throws PersistenceException {
        ContainerManagementInformation column;
        int i;
        List<ContainerManagementInformation> columns = Arrays.asList(ContainerManagementInformation.values());
        int[] columnWidths = new int[columns.size()];
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            columnWidths[i] = Math.max(column.toString().length(), ArchiveFileViewer.computeWidth(column));
        }
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (i != 0) {
                System.out.print(" | ");
            }
            System.out.print(Strings.padStart((String)ArchiveFileViewer.getString(headers, column), (int)columnWidths[i], (char)' '));
        }
        System.out.println();
    }

    private static void printContainerDataTable(DataIterator dataIterator) throws PersistenceException, SynchronizationFailedException {
        ContainerDataResult result = new ContainerDataResult();
        System.out.println("           Datenindex |         Datenzeit |        Archivzeit |                Zustand |      Bytes");
        System.out.println("======================|===================|===================|========================|===========");
        while (!dataIterator.isEmpty()) {
            dataIterator.poll(result);
            System.out.print(Strings.padStart((String)Util.dIdx2Str((long)result.getDataIndex()), (int)21, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)String.valueOf(result.getDataTime()), (int)17, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)String.valueOf(result.getArchiveTime()), (int)17, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)String.valueOf(result.getDataState()), (int)22, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)String.valueOf(result.getDataSize()), (int)10, (char)' '));
            System.out.println();
        }
    }

    private static void printDeletedBlocksTable(String contId, List<DeletedContainerFile.IndexRange> data) {
        for (DeletedContainerFile.IndexRange range : data) {
            System.out.print(Strings.padStart((String)contId, (int)13, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)Util.dIdx2Str((long)range.from()), (int)21, (char)' '));
            System.out.print(" | ");
            System.out.print(Strings.padStart((String)Util.dIdx2Str((long)range.to()), (int)21, (char)' '));
            System.out.println();
        }
    }

    @FunctionalInterface
    private static interface IndexCreator<E extends Enum<E>> {
        public AbstractIndex<E> buildIndex() throws IndexException;
    }
}

