/*
 *
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt;

/**
 * Daten-Klasse, die die Parametrierung der Queues enthält
 */
public class QueueParameters {
	private final int _totalCapacityOfQueues;
	private final long _minWaitNanosPerSubscription;
	private final long _maxWaitNanosPerSubscription;
	private final int _subscriptionSlidingWindowSize;

	/**
	 * @param totalCapacityOfQueues         Kapazität von Eingangs-Queues (Anzahl Datensätze)
	 * @param minWaitNanosPerSubscription   Minimale Wartezeit in Nanosekunden zwischen 2 Anmeldungen
	 * @param maxWaitNanosPerSubscription   Maximale Wartezeit in Nanosekunden zwischen 2 Anmeldungen
	 * @param subscriptionSlidingWindowSize Maximale Anzahl an unbestätigten gleichzeitigen Anmeldevorgängen (wird evtl. durch maxWaitNanosPerSubscription überschrieben)
	 */
	public QueueParameters(final int totalCapacityOfQueues, final long minWaitNanosPerSubscription, final long maxWaitNanosPerSubscription, final int subscriptionSlidingWindowSize) {
		_totalCapacityOfQueues = totalCapacityOfQueues;
		_minWaitNanosPerSubscription = minWaitNanosPerSubscription;
		_maxWaitNanosPerSubscription = maxWaitNanosPerSubscription;
		_subscriptionSlidingWindowSize = subscriptionSlidingWindowSize;
	}

	/**
	 * Gibt die Kapazität von der Eingangswarteschlange zurück
	 *
	 * @return Kapazität von der Eingangswarteschlange (Anzahl Datensätze)
	 */
	public int getTotalCapacityOfOnlineQueues() {
		return _totalCapacityOfQueues;
	}

	/**
	 * Gibt die minimale Wartezeit in Nanosekunden zwischen 2 Anmeldungen zurück
	 *
	 * @return Minimale Wartezeit in Nanosekunden zwischen 2 Anmeldungen
	 */
	public long getMinWaitNanosPerSubscription() {
		return _minWaitNanosPerSubscription;
	}

	/**
	 * Gibt die maximale Wartezeit in Nanosekunden zwischen 2 Anmeldungen zurück
	 *
	 * @return Maximale Wartezeit in Nanosekunden zwischen 2 Anmeldungen
	 */
	public long getMaxWaitNanosPerSubscription() {
		return _maxWaitNanosPerSubscription;
	}

	/**
	 * Gibt die maximale Anzahl an unbestätigten gleichzeitigen Anmeldevorgängen zurück
	 *
	 * @return Maximale Anzahl an unbestätigten gleichzeitigen Anmeldevorgängen
	 */
	public int getSubscriptionSlidingWindowSize() {
		return _subscriptionSlidingWindowSize;
	}
}
