/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt;

/**
 * Interface für Systemfunktionen. Wird benutzt, damit vor allem in tests eine andere Systemzeit oder sonstiges spezielles
 * Verhalten hervorgerufen werden kann.
 * <p>
 * Im normalen Betrieb wird die Implementierung {@link SystemRuntimeControl} benutzt.
 */
public interface RuntimeControl {

	/**
	 * Gibt die aktuelle Systemzeit zurück
	 *
	 * @return Systemzeit in Epoch-Millis
	 */
	long getSystemTime();

	/**
	 * Datenindex-Offset (nur für Tests)
	 */
	default long getDataIndexOffset() {
		return 0;
	}

	/**
	 * Nur für Testzwecke; falls wahr, werden nur Datensätze mit Daten archiviert. Es gibt dann keine Datensätze folgender Art: "keine Quelle", "keine Daten",
	 * "pot. Datenlücke". Manche Testverfahren werden einfacher, wenn ausschliesslich Datensätze archiviert werden, die auch gesendet wurden.
	 *
	 * @return true wenn Lückendatensätze weggelassen werden sollen
	 */
	default boolean archiveOnlyData() {
		return false;
	}

	/**
	 * Nur für Testzwecke; falls wahr, werden bei vom Datenverteiler generierte "keine Quelle"-Datensätze so
	 * angepasst, dass diese die simulierte Archivzeit besitzen und nicht die Systemzeit genommen wird.
	 *
	 * @return Zeitstempel anpassen?
	 */
	default boolean fixNoSourceDataTime() {
		return false;
	}

}
