package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

/**
 * Interface, für Funktionen, die dem {@link de.bsvrz.ars.ars.persistence.PersistenceManager} übergeben werden,
 * damit dieser Laufzeiteinstellungen abfragen kann, und überprüfen kann, ob das System beendet wird.
 * <p>
 * in der Regel ist das der {@link ArchiveManager}, kann aber für Tests eine andere Implementierung sein.     
 */
public interface TaskManagerInterface {
	
	/** 
	 * Gibt {@code true} zurück, wenn das System terminiert wurde.
	 * @return {@code true}, wenn das System terminiert wurde, sonst {@code false}
	 */
	default boolean wasTerminated() {
		return false;
	}

	/**
	 * Gibt die aktuelle Laufzeitsteuerung zurück. Falls das System noch nicht voll initialisiert ist, wird {@code null}
	 * zurückgegeben.
	 *
	 * @return die aktuelle Laufzeitsteuerung
	 */
	@Nullable
	RuntimeControl getRuntimeControl();

	/**
	 * Die Methode blockiert und hält damit den aufrufenden Task an, wenn dies (z. B. wegen Überlastung) notwendig ist.
	 *
	 * @param task Task
	 * @throws InterruptedException Unterbrochen beim Anhalten
	 */
	default void suspendTaskIfNecessary(Task task) throws InterruptedException {
	}

	default int getIndexCacheMaxSize() {
		return 1024;
	}

	default long countDataInQueues() {
		return 0;
	}

	default long estimateQueueMemoryUsage() {
		return 0;
	}

	default int getNumCloseIndexThreads() {
		return 4;
	}

	default int getNumCheckPersistenceThreads() {
		return 4;
	}
}
