/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

import java.util.*;

/**
 * Telnet-Kommando, mit dem ein Persistenz-Wochenverzeichnis sicher ausgeworfen werden kann.
 *
 * @param <T>
 */
public class EjectPersistenceDirectoriesCommand<T extends TimeRange<T>> extends Command {
	private final TimeBasedPersistenceDirectoryManager<T> directoryManager;


	/**
	 * Erstellt eine neue EjectPersistenceDirectoriesCommand-Instanz.
	 * @param directoryManager Verzeichnisverwaltung
	 */
	public EjectPersistenceDirectoriesCommand(TimeBasedPersistenceDirectoryManager<T> directoryManager) {
		super("Verzeichnisse auswerfen", "");
		this.directoryManager = directoryManager;
	}

	@Override
	public void execute() throws Exception {
		printlnPlain("  Zeitbereich, der ausgeworfen werden soll:");
		TimeDomain<T> domain = directoryManager.getDomain();
		final Set<T> timeRanges = DomainUtil.getTimeRangesFromUser(this, domain);
		if (timeRanges == null) return;
		for (T timeRange : timeRanges) {
			PersistenceDirectory directory = directoryManager.getPersistenceDirectory(timeRange);
			if (directory == null) {
				printlnPlain("  " + domain.getPath(timeRange) + ": Verzeichnis ist nicht eingebunden.");
				continue;
			}
			boolean b = directoryManager.removePersistenceDirectory(timeRange);
			if (b) {
				printlnPlain("  " + domain.getPath(timeRange) + ": Erfolgreich ausgeworfen.");
			} else {
				printlnPlain("  " + domain.getPath(timeRange) + ": Auswerfen aktuell nicht möglich.");
			}
		}
	}

}
