/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

/**
 * Kommando, um das endgültige Löschen zu aktivieren
 */
public class EnableDeleteCommand extends Command {

	private final ArchiveManager archiveManager;

	/**
	 * Konstruktor
	 *
	 * @param archiveManager Archivmanager
	 */
	public EnableDeleteCommand(ArchiveManager archiveManager) {
		super("Endgueltiges Loeschen (de)aktivieren", "");
		this.archiveManager = archiveManager;
	}

	@Override
	public void execute() throws Exception {
		archiveManager.togglePermanentDelete();
		if (archiveManager.simulatePermanentDelete()) {
			println("Das endgueltige Loeschen ist jetzt aktiv.");
		} else {
			println("Das endgueltige Loeschen ist nicht mehr aktiv.");
		}
	}

}
