/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.simulation;

import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.losb.datk.PidSimulation;

/**
 * Klasse für die Online Simulation.
 *
 * @author beck et al. projects GmbH
 * @author Martin Hilgers
 * @version $Revision$ / $Date$ / ($Author$)
 */
public final class OnlineSimulation extends SimulationAutomaton {

	/**
	 * Erzeugt das Objekt zur Online-Simulation.
	 *
	 * @param simManager Simulationverwaltung
	 * @param simulation Simulationsobjekt.
	 */
	public OnlineSimulation(SimulationManager simManager, SystemObject simulation) {
		super(
				simManager, simulation, new DataDescription(
				simManager.getDav().getDataModel().getAttributeGroup(PidSimulation.atgOnlineControl),
				simManager.getDav().getDataModel().getAspect(PidSimulation.aspState)
		)
		);
	}
}
