/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.simulation;

import de.bsvrz.dav.daf.main.ResultData;

/**
 * Klasse für Lösch- und Datenanmeldungsaufträge. Diese Aufträge werden von {@link de.bsvrz.ars.ars.mgmt.simulation.SimulationAutomaton} veranlasst.
 *
 * @author beck et al. projects GmbH
 * @author Martin Hilgers
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class SimulationResultData extends ResultData {

	/** Simulations-Automat. */
	private final SimulationAutomaton dfa;

	/**
	 * Erzeugt das Objekt. Setzt alle Werte des {@link ResultData} Objekts auf null.
	 *
	 * @param dfa Simulation.
	 */
	public SimulationResultData(SimulationAutomaton dfa) {
		super(null, null, -1L, null);
		this.dfa = dfa;
	}

	/**
	 * Erzeugt das Objekt und übernimmt die Werte aus dem übergebenen {@code ResultData} Objekt.
	 *
	 * @param dfa        Simulation
	 * @param resultData Ausgangsdaten.
	 */
	public SimulationResultData(SimulationAutomaton dfa, ResultData resultData) {
		super(
				resultData.getObject(),
				resultData.getDataDescription(),
				resultData.getDataTime(),
				resultData.getData(),
				resultData.isDelayedData(),
				resultData.getDataState()
		);
		this.dfa = dfa;
	}

	/**
	 * Wird vom Lösch-Task aufgerufen, wenn der Auftrag durchgeführt wurde.
	 *
	 * @param successful Zeigt an ob der Auftrag erfolgreich durchgeführt wurde.
	 */
	public void dataDeleted(boolean successful) {
		dfa.dataDeleted(successful);
	}

	/**
	 * Wird vom Anmeldungs-Task aufgerufen, nachdem sich das Archivsystem auf die Simulationsdaten angemeldet hat.
	 *
	 * @param successful Zeigt an ob der Auftrag erfolgreich durchgeführt wurde.
	 */
	public void doneSubscribing(boolean successful) {
		dfa.finishInitState(successful);
	}

	/** @return Liefert die Simulationsvariante zurück, die gelöscht werden soll. */
	public short getSimVar() {
		return dfa.getSimVar();
	}
}
