/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.dav.daf.main.ResultData;

/**
 * Abstrakte Basisklasse für diejenigen Tasks, die mehr als einmal vorkommen und deswegen von einem TaskMgr verwaltet werden. Die verwalteten Tasks müssen
 * völlig unabhängig voneinander sein und dürfen auch keine Reihenfolgenabhängigkeiten (wie z.B. die ArchiveTask) beinhalten.
 *
 * @author beck et al. projects GmbH
 * @author Alexander Schmidt
 * @version $Revision$ / $Date$ / ($Author$)
 */
public abstract class MultiTask extends QueueTask<ResultData> {

	/** TaskMgr der diese MultiTask verwaltet */
	private final MultiTaskManager taskMgr;

	/** Aktueller Datensatz/Anfrage/Auftrag. Muss auf null gesetzt werden wenn kein solcher vorliegt. */
	protected ResultData resultData;

	/**
	 * Konstruktor für Task.
	 *
	 * @param archiveMgr Archiv-Manager
	 * @param tMgr  Task-Manager
	 */
	public MultiTask(ArchiveManager archiveMgr, MultiTaskManager tMgr) {
		super(archiveMgr, new SignalingQueue<>());
		taskMgr = tMgr;
	}

	public void setTaskIndex(int idx) {
		setName(taskMgr.getName() + ":" + getClass().getSimpleName() + "_" + idx);
	}

	@Override
	protected final void work(final ResultData step) {
		try {
			resultData = step;
			work();
		}
		finally {
			resultData = null;
			taskMgr.pushFreeTask(this);
		}
	}

	/** Diese Methode ist zu überschreiben, um die konkrete Aufgabe der Task zu implementieren. In der Methode soll keine weitere Synchronisation stattfinden. */
	protected abstract void work();

	public void getObjectsFromDav() {
	}
}
