/*
 * Copyright 2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;

import java.io.IOException;

/**
 * Verwaltungs-Daten für den Auftrag einer Archivanfrage
 */
public sealed interface QueryData extends AutoCloseable permits QueryList, QueryError {
	static QueryData createQueryData(ArchiveManager archMgr, ArchiveDataSpecification[] ads, int archivQueryCountForApplication, int maximumRequestsPerApplication, Object queryAppObj) {
        if (archivQueryCountForApplication > maximumRequestsPerApplication) {
            return new QueryError("Zu viele parallele Archivanfragen (" + archivQueryCountForApplication + ") von der Applikation '" + queryAppObj + "'. Maximum ist: " + maximumRequestsPerApplication);
        }
		if (ads.length == 0) {
            return new QueryError("Kein Intervall gegeben");
        }
        try {
	        return new QueryList(archMgr, ads);
        } catch (Exception e) {
            return new QueryError("Fehler beim Auswerten der Archivanfrage", e);
        }
    }

	/**
	 * Gibt die Anzahl der Ergebnis-Streams zurück.
	 *
	 * @return die Anzahl der Ergebnis-Streams
	 */
    int size();

	/**
	 * Sendet die Antwort an die anfragende Applikation
	 * @param sender Sender
	 * @param mux    Stream-Multiplexer
	 * @throws IOException IO-Fehler
	 * @throws InterruptedException Unterbrochen?
	 */
    void sendReply(ArchiveQueryTask.ResponseSender sender, StreamMultiplexer mux) throws IOException, InterruptedException;

	/**
	 * Gibt das untergeordnete Anfrageobjekt für den angegebenen Stream zurück (siehe {@link #size()} für gültige Indexe)
	 * @param indexOfStream Index
	 * @return Eigentliche Sub-Anfrage
	 */
    Query get(int indexOfStream);
}
