/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;

import java.io.IOException;

/**
 * Fehler bei einer Archivanfrage, führt zu einer Fehler-Antwort. Enthält keine Daten.
 */
public final class QueryError extends Exception implements QueryData {
	public QueryError(String errorMessage, Exception e) {
		super(errorMessage, e);
	}

	public QueryError(String s) {
		super(s);
	}

	@Override
	public int size() {
		return 0;
	}

	@Override
	public void sendReply(ArchiveQueryTask.ResponseSender sender, StreamMultiplexer mux) throws IOException {
		sender.sendInitialResponse(false, getMessage());
	}

	@Override
	public Query get(int indexOfStream) {
		throw new IndexOutOfBoundsException("Index: " + indexOfStream);
	}

	@Override
	public void close() {
	}
}
