/*
 * Copyright 2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;

/**
 * Klasse, die einen Archivdatensatz mit den zugehörigen Zeitstempeln und Datenindex kapselt.
 *
 * @param arcTime    Zeitstempel / Datenindex
 * @param dataKind   Datensatzart
 * @param dataState  Zustand des Datensatzes (Datensatztyp).
 * @param rawData    serialisierter Datensatz
 * @param compressed komprimiert?
 */
public record SimpleArchiveData(long arcTime, long dataTime, long dataIdx, ArchiveDataKind dataKind,
                                DataState dataState,
                                boolean compressed, @Nullable byte[] rawData) {

	public String toString() {
		return "dx=" + Util.dIdx2StrExt(dataIdx) + " (" + dataIdx + ")  dt=" + Util.timestrMillisFormatted(dataTime) + "  at="
				+ Util.timestrMillisFormatted(arcTime) + "  " + dataKind + "  " + dataState;
	}
}
