/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

/**
 * Einfache Task-Implementierung, die im {@link TaskManager} verwendet wird.
 */
class ShortTermTask implements Task {
	private TaskState taskState;
	private long progress;
	private long maximumProgress;
	private long result;
	private String text;
	private final String name;

	/**
	 * Erzeugt eine neue Instanz
	 *
	 * @param name Name des Tasks
	 */
	public ShortTermTask(String name) {
		this.name = name;
	}

	@Override
	public void setTaskState(TaskState taskState) {
		this.taskState = taskState;
	}

	@Override
	public void setTaskProgress(String format, long progress, long maximumProgress, long result) {
		this.progress = progress;
		this.maximumProgress = maximumProgress;
		this.result = result;
		this.text = format.formatted(progress, this.maximumProgress, this.result);
	}

	@Override
	public String getProgressText() {
		return text;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public TaskState getState() {
		return taskState;
	}

	@Override
	public long getProgress() {
		return progress;
	}

	@Override
	public long getMaximumProgress() {
		return maximumProgress;
	}

	@Override
	public long getProgressResult() {
		return result;
	}
}
