/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

/**
 * Schnittstelle, die von den einzelnen Tasks verwendet wird, um den Zustand der Task und den Fortschritt von langwierigen Aktionen zu dokumentieren.
 */
public interface Task extends TaskProgressInterface {

	/**
	 * Setzt den Zustand eines Tasks.
	 *
	 * @param taskState Neuer Zustand.
	 */
	void setTaskState(TaskState taskState);

	/**
	 * Gibt einen Text zurück, der den Fortschritt darstellt. Zum Beispiel:
	 * {@code "Datenanalyse läuft. 10 von 100 Containern besucht."}
	 *
	 * @return beliebiger Text
	 */
	String getProgressText();

	/**
	 * Gibt den Namen des Tasks zurück
	 *
	 * @return Name (Freitext)
	 */
	String getName();

	/**
	 * Gibt den Zustand des Tasks zurück
	 *
	 * @return Zustand
	 */
	TaskState getState();

	/**
	 * Gibt den Fortschritt zurück (Z. B. Anzahl bisher bearbeitete Objekte als Anteil von {@link #getMaximumProgress()}).
	 * <p>
	 * Ist der Fortschritt unbekannt, kann -1 zurückgegeben werden.
	 *
	 * @return Fortschritt
	 */
	long getProgress();

	/**
	 * Gibt den Maximalwert von {@link #getProgress()} zurück, also z. B. die Gesamtzahl der zu bearbeitenden Objekte.
	 * <p>
	 * Ist keine Gesamtzahl bekannt, kann -1 zurückgegeben werden.
	 *
	 * @return Maximaler Fortschritt
	 */
	long getMaximumProgress();

	/**
	 * Gibt Optional eine Ergebnisanzahl zurück, z. B. die Anzahl der besuchten Container in einem Durchlauf.
	 * Diese Zahl ist unabhängig von {@link #getProgress()} bzw. {@link #getMaximumProgress()}.
	 * <p>
	 * Falls nicht benötigt, kann -1 zurückgegeben werden.
	 *
	 * @return Ergebnis-Anzahl
	 */
	long getProgressResult();

}
