/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

/**
 * Erlaubt die Publizierung von Task-Fortschritten im {@link TaskManager}.
 */
public interface TaskProgressInterface {
	/**
	 * Setzt den Fortschritt einer Task. Im Falle einer Ausgabe werden der übergebene Formatstring und die weiteren Parameter an die Methode
	 * Formatter.format() übergeben um den auszugebenden Text zu ermitteln.
	 *
	 * @param format          Formatstring, der bei Ausgaben dazu verwendet wird, eine textuelle Beschreibung des aktuellen Fortschritts zu erzeugen.
	 * @param progress        Fortschritt der aktuellen Aktion oder {@code -1}, wenn der Fortschritt nicht bekannt ist.
	 * @param maximumProgress Maximum des Fortschritts einer Aktion oder {@code -1}, wenn das Maximum nicht bekannt ist.
	 * @param result          Zwischenergebnis der aktuell durchgeführten Aktion oder {@code -1}, wenn kein Zwischenergebnis bekannt ist.
	 */
	void setTaskProgress(String format, long progress, long maximumProgress, long result);
}
