/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

/**
 * Funktionales Interface für Funktionen, die mit einem Timeout ausgeführt werden.
 * Nach Ablauf des Timeouts wird der Thread, der die Methode ausführt mit einem Interrupt unterbrochen.
 * Der Funktion wird ein {@link TimeoutCallback} übergeben, wo mit Aufruf der {@link TimeoutCallback#tick()}-Methode
 * der Timeout erneuert werden kann, oder es kann mit {@link TimeoutCallback#cancel()} der Timeout beendet werden,
 * was dazu führt, dass die restliche Methode danach ohne weitere Unterbrechung durchgeführt wird,
 * egal ob dann der Timeout abläuft.
 *
 * @param <T>
 */
@FunctionalInterface
public interface TimeoutFunction<T> {

	/**
	 * Implementierung der Methode mit Timeout
	 *
	 * @param callback Callback um den Timeout zu verlängern (z. B. nach einem erfolgreich durchgeführten Schritt)
	 *                 oder abzubrechen
	 * @return Ergebnis der Funktion
	 * @throws InterruptedException Aufruf wurde unterbrochen (z. B. durch Timeout)
	 */
	T call(TimeoutCallback callback) throws InterruptedException;

}
