/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.query;

import de.bsvrz.sys.funclib.dataSerializer.Serializer;

import java.io.IOException;

/**
 * Hilfsinterface, mit dem in {@link QueryHandler#sendResponse(int, boolean, String, DataWriter)} zusätzliche
 * Daten in den serialisierten Datenstrom integriert werden können
 */
public interface DataWriter {

	/**
	 * Eine Implementierung des Interfaces kann hier weitere Daten in den übergebenen Serialisierer schreiben.
	 *
	 * @param serializer {@link Serializer}
	 * @throws IOException IO-Fehler kann an den Aufrufer weitergegeben werden
	 */
	void accept(Serializer serializer) throws IOException;

}
