/*
 *
 * Copyright 2018-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

import java.util.Iterator;
import java.util.LinkedHashSet;

/**
 *
 *
 * @author Kappich Systemberatung
 */
public class CollectionUtilities {
	private CollectionUtilities() {
		throw new AssertionError();
	}

	/**
	 * Entfernt den ältesten Eintrag aus dem LinkedHashSet und gibt ihn zurück. Falls das Set leer ist, wird es nicht verändert und null zurückgegeben.
	 * @param set Menge
	 * @return ältestes Element
	 * @param <T> Typ der Elemente
	 */
	@Nullable
	public static <T> T removeOldest(final LinkedHashSet<T> set) {
		// TODO: Ab Java 21 Sequenced Collection-Funktion benutzen
		
		if(set.isEmpty()) return null;
		Iterator<T> iterator = set.iterator();
		T next = iterator.next();
		iterator.remove();
		return next;
	}
}
