/*
 *
 * Copyright 2017-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence;

/**
 *
 *
 * @author Kappich Systemberatung
 */
public interface ContainerManagementData {
	/**
	 * Liefert den Wert des Parameters als String-Wert zurück. Wirft eine {@link PersistenceException}, falls der Parameter nicht gefunden wurde.
	 *
	 * @param param Container-Header-Parameter
	 * @return Parameter-Wert als String
	 * @see KeyValParam
	 * @throws PersistenceException Lesefehler im Persistenzverzeichnis
	 */
	String getContainerHeaderParamAsString(ContainerManagementInformation param) throws PersistenceException;

	/**
	 * Liefert den Wert des Parameters als boolschen Wert zurück. Wirft eine {@link PersistenceException}, falls der Parameter nicht gefunden wurde oder nicht
	 * in den Typ {@code boolean} umgeformt werden kann.
	 *
	 * @param param Container-Header-Parameter
	 * @return {@code true} oder {@code false}
	 * @throws PersistenceException Lesefehler im Persistenzverzeichnis
	 */
	boolean getContainerHeaderParamAsBoolean(ContainerManagementInformation param) throws PersistenceException;

	/**
	 * Liefert den Wert des Parameters als numerischen Wert vom Typ {@code long} zurück. Wirft eine {@link PersistenceException}, falls der Parameter nicht
	 * gefunden wurde oder nicht in den Typ {@code long} umgeformt werden kann.
	 *
	 * @param param Container-Header-Parameter
	 * @return Ganzzahl als {@code long}
	 * @throws PersistenceException Lesefehler im Persistenzverzeichnis
	 */
	long getContainerHeaderParamAsLong(ContainerManagementInformation param) throws PersistenceException;

	/**
	 * Liefert den Wert des Parameters als numerischen Wert vom Typ {@code long} zurück. Wirft eine {@link PersistenceException}, falls der Parameter nicht
	 * gefunden wurde oder nicht in den Typ {@code long} umgeformt werden kann.
	 *
	 * @param param Container-Header-Parameter
	 * @return Ganzzahl als {@code long}
	 * @throws PersistenceException Lesefehler im Persistenzverzeichnis
	 */
	int getContainerHeaderParamAsInt(ContainerManagementInformation param) throws PersistenceException;

	/**
	 * Gibt den Ort des Containers zurück
	 * @return den Ort des Containers
	 */
	ContainerDirectory getLocation() throws PersistenceException;

}
