/*
 *
 * Copyright 2017-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence;

/**
 * Enum der möglichen Verwaltungsinformationen eines Containers. Dieses Enum definiert die Spalten im Verwaltungsdatenindex.
 * Dieses Enum entspricht den Container-Header-Parametern, allerdings sind Werte, die bei jeden Container einer Datenidentifikation gleich
 * sind, wie Objekt, Attributgruppe, Aspekt, Datenart, Simulationsvariante nicht enthalten.
 *
 * @author Kappich Systemberatung
 */
public enum ContainerManagementInformation {
	/**
	 * Container-ID
	 */
	CHP_CONT_ID(ContainerHdr.CHP_CONT_ID),
	/**
	 * Anzahl Datensätze
	 */
	CHP_ANZ_DS(ContainerHdr.CHP_ANZ_DS),
	/**
	 * Datenindex-Minimum
	 */
	CHP_DATA_IDX_MIN(ContainerHdr.CHP_DATA_IDX_MIN),
	/**
	 * Datenindex-Maximum
	 */
	CHP_DATA_IDX_MAX(ContainerHdr.CHP_DATA_IDX_MAX),
	/**
	 * Datenzeit-Minimum
	 */
	CHP_DATA_TIME_MIN(ContainerHdr.CHP_DATA_TIME_MIN),
	/**
	 * Datenzeit-Maximum
	 */
	CHP_DATA_TIME_MAX(ContainerHdr.CHP_DATA_TIME_MAX),
	/**
	 * Archivzeit-Minimum
	 */
	CHP_ARC_TIME_MIN(ContainerHdr.CHP_ARC_TIME_MIN),
	/**
	 * Archivzeit-Maximum
	 */
	CHP_ARC_TIME_MAX(ContainerHdr.CHP_ARC_TIME_MAX),
	/**
	 * Soll der Container gesichert werden?
	 */
	CHP_TO_SAVE(ContainerHdr.CHP_TO_SAVE),
	/**
	 * Medien-ID des gesicherten Containers oder MEDIUM_UNSAVED oder MEDIUM_DESTROYED
	 */
	CHP_MEDIUM_ID(ContainerHdr.CHP_MEDIUM_ID),
	/**
	 * Löschzeitpunkt
	 */
	CHP_LOESCHEN(ContainerHdr.CHP_LOESCHEN),
	/**
	 * Löschschutz bis zum angegebenen Zeitpunkt
	 */
	CHP_LOESCHUTZ(ContainerHdr.CHP_LOESCHUTZ),
	/**
	 * Ist der Container gelöscht?
	 */
	CHP_DELETED(ContainerHdr.CHP_DELETED),
	/**
	 * Ist der Container wiederhergestellt?
	 */
	CHP_RESTORED(ContainerHdr.CHP_RESTORED),
	;

	private final KeyValParam _param;

	ContainerManagementInformation(KeyValParam param) {
		_param = param;
	}

	/**
	 * Gibt den Key (Namen) der Verwaltungsinformation zurück
	 * @return den Key (Namen) der Verwaltungsinformation
	 */
	public String getKey() {
		return _param.getKey();
	}

	/**
	 * Gibt die Anzahl an Zeichen zurück, die von diesem Parameter als String formatiert benötigt werden
	 * @return Anzahl Zeichen
	 */
	public int getValLen() {
		return _param.getValLen();
	}

	/**
	 * Gibt {@code true} zurück, wenn die Information als Zahl gespeichert wird
	 * @return {@code true}, wenn die Information als Zahl gespeichert wird, sonst ({@code false}) wird ein Strign gespeichert
	 */
	public boolean isNumeric() {
		return _param.isNumeric();
	}

	@Override
	public String toString() {
		return getKey();
	}

	/**
	 * Gibt die (fixe) Anzahl Bytes zurück, die benötigt werden um einen Wert zu speichern.
	 * @return die (fixe) Anzahl Bytes
	 */
	public int getByteLength() {
		return _param.getByteLength();
	}

	/**
	 * Verweie auf die Ursprüngliche Implementierung in {@link KeyValParam}
	 * @return Ursprüngliche Instanz der ContainerHeader-Parameter
	 */
	public KeyValParam delegate() {
		return _param;
	}
}
