/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence;

import java.io.Serial;

/**
 * Exception für Fehler in der Persistenz. Dabei handelt es sich in der Regel um gekapselte {@link java.io.IOException}s,
 * die Auftreten, wenn z. B. auf Containerdateien zugegriffen werden soll, oder wenn eine Datei nicht das korrekte Format hat. 
 *
 * @author beck et al. projects GmbH
 * @author Thomas Schaefer
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class PersistenceException extends Exception {

	@Serial
	private static final long serialVersionUID = 1L;

	/**
	 * Erzeugt eine neue PersistenceException.
	 *
	 * @param msg Fehlermeldung
	 */
	public PersistenceException(String msg) {
		super(msg);
	}

	/**
	 * Erzeugt eine neue PersistenceException.
	 *
	 * @param msg   Fehlermeldung
	 * @param cause Ursache, {@code null} ist erlaubt bei unbekannter Ursache
	 */
	public PersistenceException(String msg, Throwable cause) {
		super(msg, cause);
	}

	/**
	 * Erzeugt eine neue PersistenceException.
	 *
	 * @param cause Ursache, {@code null} ist erlaubt bei unbekannter Ursache
	 */
	public PersistenceException(Throwable cause) {
		super(cause);
	}
}
