/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.repair.ScanMode;

public enum ScanModes {
	Directory("Verzeichnis", new ScanMode(false, false, false, false, false, false)),
	Header("Header", new ScanMode(true, true, true, false, false, false)),
	All("Alles", new ScanMode(true, true, true, true, false, false)),
	FixErrors("Korrektur", new ScanMode(true, true, true, true, true, true));

	private final String name;
	private final ScanMode scanMode;

	ScanModes(String name, ScanMode scanMode) {
		this.name = name;
		this.scanMode = scanMode;
	}

	public ScanMode get() {
		return scanMode;
	}

	@Override
	public String toString() {
		return name;
	}
}
