/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.directories;

import de.bsvrz.ars.ars.persistence.*;
import de.bsvrz.ars.ars.persistence.directories.cache.DataRange;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Diese Klasse steht für ein abgeschlossenes Persistenzverzeichnis
 */
public final class ReadonlyPersistenceDirectory extends PersistenceDirectory {

	private Map<IdContainerFileDir, DataRange> rangeCacheMap = new ConcurrentHashMap<>();

	/**
	 * Erstellt ein neues ClosedPersistenceDirectory.
	 *
	 * @param dataIdentificationManager Klasse zum Zugriff auf Indexe (Im Normalbetrieb der {@link PersistenceManager})
	 * @param layoutInstance            Instanz eines Verzeichnis-Layouts
	 */
	public ReadonlyPersistenceDirectory(@NotNull DataIdentificationManager dataIdentificationManager, @NotNull PersistenceDirectoryLayoutInstance layoutInstance) {
		super(dataIdentificationManager, layoutInstance);
	}

	@Override
	public DataRange getDataRange(LockedContainerDirectory directory) throws IndexException {
		try {
			return rangeCacheMap.computeIfAbsent(IdContainerFileDir.of(directory), (it) -> computeDataRange(directory));
		}
		catch (RuntimeException e) {
			if(e.getCause() instanceof IndexException idx) {
				throw idx;
			}
			throw e;
		}
	}

}
