/*
 * Copyright 2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.index;

import com.google.common.collect.ImmutableMap;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.LongRange;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;

/**
 * TBD Dokumentation
 *
 * @author Kappich Systemberatung
 */
public interface ArchiveTimeIndex extends BaseIndex<IndexValues> {
	/**
	 * Liefert die IDs der Container, deren Archivzeitspanne sich mit der angegebenen Spanne überschneidet.
	 *
	 * @param minATime Beginn der Zeitspanne
	 * @param maxATime Ende der Zeitspanne
	 *
	 * @return Liste von ContainerIDs mit Min/Max-Werten von DI, AT, DT
	 *
	 * @throws IndexException Lesefehler der Indexe (z. B. korrupt)
	 */
	default IndexResult<IndexValues> getContainerIDByArchiveTime(long minATime, long maxATime) throws IndexException {
		return getContainerID(IndexValues.ArchiveTimeMin, IndexValues.ArchiveTimeMax, minATime, maxATime);
	}

	/**
	 * Liefert die IDs der Container, bei denen der gesuchte Key zwischen Anfang und Ende liegt.
	 *
	 * @return Liste von ContainerIDs mit Min/Max-Werten von DI, AT, DT
	 * @throws IndexException Lesefehler der Indexe (z. B. korrupt)
	 */
	default IndexResult<IndexValues> getContainerID(IndexValues minColumn, IndexValues maxColumn, long minKey, long maxKey) throws IndexException {
		return query(ImmutableMap.of(maxColumn, new LongRange(minKey, null), minColumn, new LongRange(null, maxKey)));
	}
}
