/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.index;

import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import java.nio.file.Path;

/**
 * In dieser Klasse ist zusaetzlich gefordert, dass die Folge der Datenindexe streng monoton ist.
 *
 * @author beck et al. projects GmbH
 * @author Phil Schrettenbrunner
 * @author Alexander Schmidt
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class DataIndexAndArchiveTimeIndex extends ArchiveTimeIndexImpl implements DataIndexIndex {

	private static final IndexContentDescriptor<IndexValues> INDEX_CONTENT_DESCRIPTOR;

	static {
		INDEX_CONTENT_DESCRIPTOR = new IndexContentDescriptor<>(IndexValues.class);
		INDEX_CONTENT_DESCRIPTOR.addRange(8, IndexValues.DataIndexMin, ColumnType.StrictlyIncreasing, IndexValues.DataIndexMax, ColumnType.StrictlyIncreasing);
		INDEX_CONTENT_DESCRIPTOR.addRange(6, IndexValues.ArchiveTimeMin, ColumnType.Increasing, IndexValues.ArchiveTimeMax, ColumnType.Increasing);
		INDEX_CONTENT_DESCRIPTOR.addRange(6, IndexValues.DataTimeMin, ColumnType.Unordered, IndexValues.DataTimeMax, ColumnType.Unordered);
		INDEX_CONTENT_DESCRIPTOR.addColumn(5, IndexValues.ContainerId, ColumnType.StrictlyIncreasing);
	}


	/**
	 * Erzeugt einen neuen Index
	 * @param bufferSize Puffergröße
	 * @throws CorruptIndexException Fehler beim initialisieren (z.B. bestehende Datei defekt)
	 */
	public DataIndexAndArchiveTimeIndex(final int bufferSize, final Path file) throws CorruptIndexException {
		super(bufferSize, file, INDEX_CONTENT_DESCRIPTOR);
	}

	/**
	 * Anfrage nach Datenindex
	 * @param minKey Minimum-Datenindex
	 * @param maxKey Maximum-Datenindex
	 * @return Liste mit Container-IDs
	 * @throws IndexException Lesefehler der Indexe (z. B. korrupt)
	 */
	@Override
	public IndexResult<IndexValues> getContainerIDByDataIndex(long minKey, long maxKey) throws IndexException {
		return getContainerID(IndexValues.DataIndexMin, IndexValues.DataIndexMax, minKey, maxKey);
	}
}
