/*
 * Copyright 2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.index;

import com.google.common.collect.ImmutableMap;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.LongRange;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;

/**
 * TBD Dokumentation
 *
 * @author Kappich Systemberatung
 */
public interface DataTimeIndex extends BaseIndex<IndexValues> {
	/**
	 * Liefert eine Matrix mit DTMin/Max, DIMin/Max und ContainerIds, deren DTMin/Max-Werte zwischen dTMin und dTMax liegen. Wird diese Methode aufgerufen wenn der
	 * Cache noch leer ist, werden die aktuellsten Daten aus der Datei nachgeladen.
	 *
	 * @param dTMin Min-Wert der Zeitspanne
	 * @param dTMax Max-Wert der Zeitspanne
	 * @return IndexResult-Objekt, das die Index innerhalb der gesuchten Zeitspanne enthält (DT und DI Werte, keine AT Werte)
	 * @throws IndexException Bei Problemem mit der IndexDatei
	 */
	default IndexResult<IndexValues> getContainerIDByDataTime(long dTMin, long dTMax) throws IndexException {
		// Der DatenZeitMaximum des Containers muss größer als das Anfrageminimum sein und der DatenZeitMinimum des Containers muss kleiner als das AnfrageMaximum sein.
		// Spezialfälle, wie dass ggf. der Container vor dem Anfrageminimum zurückgeliefert muss, werden von der Implementierung beachtet.
		return query(ImmutableMap.of(IndexValues.DataTimeMax, new LongRange(dTMin, null), IndexValues.DataTimeMin, new LongRange(null, dTMax)));
	}
}
