/*
 * Copyright 2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.util;

/**
 * Ergebnis-Statistik eines datenkonsistenten Backups
 *
 * @author Kappich Systemberatung
 */
public class SyncResult {
	private final long _filesCopied;
	private final long _filesRemoved;
	private final long _bytesCopied;

	/**
	 * Erstellt eine neue SyncResult.
	 *
	 * @param filesCopied  Kopierte Dateien
	 * @param filesRemoved Aus dem Zielverzeichnis gelöschte Dateien
	 * @param bytesCopied  Kopierte Bytes
	 */
	public SyncResult(final long filesCopied, final long filesRemoved, final long bytesCopied) {
		_filesCopied = filesCopied;
		_filesRemoved = filesRemoved;
		_bytesCopied = bytesCopied;
	}

	public long getFilesCopied() {
		return _filesCopied;
	}

	public long getFilesRemoved() {
		return _filesRemoved;
	}

	public long getBytesCopied() {
		return _bytesCopied;
	}

	@Override
	public boolean equals(final Object o) {
		if(this == o) return true;
		if(o == null || getClass() != o.getClass()) return false;

		final SyncResult that = (SyncResult) o;

		if(_filesCopied != that._filesCopied) return false;
		if(_filesRemoved != that._filesRemoved) return false;
		return _bytesCopied == that._bytesCopied;
	}

	@Override
	public int hashCode() {
		int result = (int) (_filesCopied ^ (_filesCopied >>> 32));
		result = 31 * result + (int) (_filesRemoved ^ (_filesRemoved >>> 32));
		result = 31 * result + (int) (_bytesCopied ^ (_bytesCopied >>> 32));
		return result;
	}

	@Override
	public String toString() {
		return "SyncResult{" +
				"_filesCopied=" + _filesCopied +
				", _filesRemoved=" + _filesRemoved +
				", _bytesCopied=" + _bytesCopied +
				'}';
	}
}
