/*
 *
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.walk;

import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.DataIdentificationDir;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;

import java.util.Collection;

/**
 * Eine Aktion, die auf einen Container angewendet werden kann
 *
 * @author Kappich Systemberatung
 */
@FunctionalInterface
public interface ContainerAction {

	/**
	 * Führt die Aktion aus.
	 *
	 * @param dataIdentificationDir Verzeichnis des Containers
	 * @param containerDirectory    Interne Referenz auf die Datenidentifikation und Art mit Zugriffs-Lock
	 * @param headers               Liste mit Containern dieser DataIdentNode
	 * @throws Exception Beliebige Exception (führt zum Abbruch der Operation)
	 */
	void run(DataIdentificationDir dataIdentificationDir, LockedContainerDirectory containerDirectory, Collection<ContainerHeaders> headers) throws Exception;

	/**
	 * Wird (unsynchronisiert) vor dem Betreten eines Verzeichnisses ausgeführt. Hier wäre der richtige Ort,
	 * um Abbruchbedingungen zu prüfen oder {@link Task#suspendTaskIfNecessary()} auszuführen.
	 *
	 * @param dataIdentificationDir Verzeichnis des Containers
	 */
	default void preVisitDirectory(DataIdentificationDir dataIdentificationDir){}
}
