/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.walk.internal;

/**
 * Interface, dass eine Abschätzung einer Anzahl von z. B. Datenidentifikationen erlaubt.
 */
public interface CountEstimator {

	/**
	 * Diese Factory-Methode kann benutzt werden, wenn die tatsächliche Anzahl bekannt ist und keine
	 * Abschätzung notwendig ist.
	 *
	 * @param actualSize tatsächliche Anzahl
	 * @return CountEstimator mit festem Wert
	 */
	static CountEstimator fixed(long actualSize) {
		return new CountEstimator() {
			@Override
			public long estimate() {
				return actualSize;
			}

			@Override
			public void setCount(long actualCount) {
			}
		};
	}

	/**
	 * Schätzt eine Anzahl
	 * @return geschätzte Anzahl. Der Wert muss größer-gleich 0 sein
	 * und sollte der realen Anzahl möglichst gut entsprechen.
	 */
	long estimate();

	/**
	 * Wird aufgerufen, wenn die richtige Anzahl (einmalig als Schnappschuss) ermittelt wurde. 
	 * Eine Implementierung kann (muss aber nicht) den Wert nutzen, um zukünftige Schätzungen zu aktualisieren.
	 * @param actualCount Momentanwert der tatsächlichen Anzahl
	 */
	void setCount(long actualCount);
}
