/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Eine Instanz dieser Klasse wird eingefuegt, wenn ein Container aufgrund einer Parametrierungs-Änderung abgeschlossen werden soll.
 */
public record CloseContainerObject(IdDataIdentification did) implements ArchiveJob {

	private static final Debug _debug = Debug.getLogger();

	@Override
	public void accept(ArchiveTask archiveTask) {

		ActivePersistenceDirectory persistenceDirectory = archiveTask.getPersistenceManager().getActivePersistenceDirectory(did.getSimVariant());

		if (persistenceDirectory == null) {
			return;
		}

		try (SyncKey<IdDataIdentification> lock = archiveTask.getPersistenceManager().lockIndex(did)) {
			for (ArchiveDataKind dataKind : ArchiveDataKindCombination.all()) {
				persistenceDirectory.closeOpenContainer(new LockedContainerDirectory(lock, dataKind));
			}
			archiveTask.getCloseCounter().incrementAndGet();
		} catch (Exception e) {
			_debug.error("Fehler beim Abschliessen eines Containers: " + e.getMessage() + Debug.NEWLINE + this, e);
		}
	}

	@Override
	public long estimateMemoryUsage() {
		return 74;
	}
}
