/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.repair;

import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

import java.nio.file.Path;
import java.util.Set;

/**
 * Gefundener Fehler im Persistenzverzeichnis
 */
public class Defect {

	private final Path _file;

	private final String _message;

	private final Exception _exception;

	/**
	 * Erstellt einen neuen Defect.
	 *
	 * @param file      Fehlerhafte Datei
	 * @param category  Liste mit Fehlern zu der dieser Defekt gehört. {@code this} wird automatisch zu dieser Fehlerliste hinzugefügt.
	 * @param message   Fehlermeldung/-Beschreibung
	 * @param exception Eventuelle Exception, die den Fehler ausgelöst hat
	 */
	public Defect(@NotNull final Path file, @NotNull final Set<Defect> category, @NotNull final String message, @Nullable Exception exception) {
		_file = file;
		_message = message;
		_exception = exception;
		category.add(this);
	}

	/**
	 * Erstellt einen neuen Defect.
	 *
	 * @param file     Fehlerhafte Datei
	 * @param category Liste mit Fehlern zu der dieser Defekt gehört. {@code this} wird automatisch zu dieser Fehlerliste hinzugefügt.
	 * @param message  Fehlermeldung/-Beschreibung
	 */
	public Defect(final Path file, final Set<Defect> category, final String message) {
		this(file, category, message, null);
	}

	/**
	 * Gibt die Datei zurück.
	 *
	 * @return die Datei
	 */
	@NotNull
	public Path getFile() {
		return _file;
	}

	/**
	 * Gibt die Fehlermeldung zurück.
	 *
	 * @return die Fehlermeldung
	 */
	@NotNull
	public String getMessage() {
		return _message;
	}

	/**
	 * Gibt die Exception zurück.
	 *
	 * @return die Exception
	 */
	@Nullable
	public Exception getException() {
		return _exception;
	}
}
