/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.repair;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RescueResult {
	private final Set<Defect> cantFix = ConcurrentHashMap.newKeySet();
	private final Set<Defect> oneByteShortDefects = ConcurrentHashMap.newKeySet();
	private final Set<Defect> badRangeEndDefects = ConcurrentHashMap.newKeySet();
	private final Set<Defect> badContainerFileEnd = ConcurrentHashMap.newKeySet();
	private final Set<Defect> shortContainerFiles = ConcurrentHashMap.newKeySet();
	private final Set<Defect> badIndexFiles = ConcurrentHashMap.newKeySet();
	private final AtomicLong validContainerFileCount = new AtomicLong();
	private final AtomicLong checkedContainerFileCount = new AtomicLong();
	private final AtomicLong defectContainerFileCount = new AtomicLong();
	private final AtomicLong validIndexFileCount = new AtomicLong();
	private final AtomicLong checkedIndexFileCount = new AtomicLong();
	private final AtomicLong defectIndexFileCount = new AtomicLong();
	private final AtomicLong correctedDefectCount = new AtomicLong();
	private final AtomicInteger deletedFiles = new AtomicInteger();
	private final AtomicLong dataIdentificationsVisited = new AtomicLong();

	public int getFixableDefectsCount() {
		return getOneByteShortDefects().size() + getBadRangeEndDefects().size() + getBadContainerFileEnd().size() + getBadIndexFiles().size();
	}

	public Set<Defect> getCantFix() {
		return cantFix;
	}

	public Set<Defect> getOneByteShortDefects() {
		return oneByteShortDefects;
	}

	public Set<Defect> getBadRangeEndDefects() {
		return badRangeEndDefects;
	}

	public Set<Defect> getBadContainerFileEnd() {
		return badContainerFileEnd;
	}

	public Set<Defect> getShortContainerFiles() {
		return shortContainerFiles;
	}

	public Set<Defect> getBadIndexFiles() {
		return badIndexFiles;
	}

	public long getValidContainerFileCount() {
		return validContainerFileCount.get();
	}

	public long getCheckedContainerFileCount() {
		return checkedContainerFileCount.get();
	}

	public long getDefectContainerFileCount() {
		return defectContainerFileCount.get();
	}

	public long getValidIndexFileCount() {
		return validIndexFileCount.get();
	}

	public long getCheckedIndexFileCount() {
		return checkedIndexFileCount.get();
	}

	public long getDefectIndexFileCount() {
		return defectIndexFileCount.get();
	}

	public long getCorrectedDefectCount() {
		return correctedDefectCount.get();
	}

	public int getDeletedFiles() {
		return deletedFiles.get();
	}

	public void incrCorrectedDefectCount(long correctedDefectCount) {
		this.correctedDefectCount.addAndGet(correctedDefectCount);
	}

	public void incrCheckedIndexFileCount() {
		this.checkedIndexFileCount.getAndIncrement();
	}

	public void incrValidIndexFileCount() {
		this.validIndexFileCount.getAndIncrement();
	}

	public void incrDefectIndexFileCount() {
		this.defectIndexFileCount.getAndIncrement();
	}

	public void incrDeletedFiles() {
		this.deletedFiles.getAndIncrement();
	}

	public void incrCheckedContainerFileCount() {
		this.checkedContainerFileCount.getAndIncrement();
	}

	public void incrValidContainerFileCount() {
		this.validContainerFileCount.getAndIncrement();
	}

	public void incrDefectContainerFileCount() {
		this.defectContainerFileCount.getAndIncrement();
	}

	public boolean isConsistent() {
		return defectIndexFileCount.get() == 0 && defectContainerFileCount.get() == 0;
	}

	public void incrDataIdentificationsVisited() {
		dataIdentificationsVisited.getAndIncrement();
	}

	public long getDataIdentificationsVisited() {
		return dataIdentificationsVisited.get();
	}
}
