/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.repair;

/**
 * Attribute, wie ein Überprüfungslauf der {@link PersistenceCheckRunner}-Klasse durchgeführt werden soll.
 *
 * @param indexFiles                 Sollen Indexdateien auf korrektes Format überprüft werden?
 * @param containerFiles             Sollen Containerdateien auf korrektes Format und häufige Fehler überprüft werden?
 * @param indexHeaderConsistency     Sollen die Indexdateien auf konsistenz mit den Containerheadern überprüft werden?
 * @param containerHeaderConsistency Sollen die Container-Header auf Konsistenz mit den Containerdaten überprüft werden?
 * @param deleteBackupIndexFiles     Sollen die veralteten Backup-Index-Dateien automatisch gelöscht werden?
 * @param fixErrors                  Sollen gefundene Fehler gelöscht werden?
 */
public record ScanMode(
		boolean indexFiles,
		boolean containerFiles,
		boolean indexHeaderConsistency,
		boolean containerHeaderConsistency,
		boolean deleteBackupIndexFiles,
		boolean fixErrors
) {
}
