/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.persistence;

import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.impl.archive.ArchiveDataCompression;
import de.bsvrz.dav.daf.main.impl.archive.DataContainerIdentification;
import de.bsvrz.dav.daf.main.impl.archive.DataTiming;
import de.bsvrz.dav.daf.main.impl.archive.PersistentContainerData;
import de.bsvrz.dav.daf.main.impl.archive.PersistentData;
import de.bsvrz.dav.daf.main.impl.archive.PersistentDataContainer;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Container
implements PersistentDataContainer {
    private static final String _k2sWriting = "K2S Container";
    private final long _containerId;
    private int _serializerVersion = -1;
    private int _dataCount = 0;
    private long _containerSize = -1L;
    private final Path _containerFile;
    private int _labelTypeB = -1;
    private DataTiming _minimumDataTiming;
    private DataTiming _maximumDataTiming;
    private boolean _containerFinalized = false;
    private boolean _storeContainer = false;
    private long _deleteTime = -1L;
    private IdContainerFileDir _dataContainerIdentification;
    private long _dataOffset;
    private static final int NUMBER_OF_DIRECTORIES = 100;
    private static final int NUMBER_OF_LAYERS = 8;
    private static final int NUMBER_OF_CONTAINERS = 1000;
    public static final String FILE_ENDING = ".arsaw";
    private static final Debug _debug = Debug.getLogger();

    public Container(long containerId, Path rootFolder) throws IOException, IllegalStateException, IllegalArgumentException {
        this._containerId = containerId;
        this._containerFile = this.getContainerDirectory(containerId, rootFolder).resolve(this._containerId + FILE_ENDING);
        this.loadContainerTypeA();
    }

    private void loadContainerTypeA() throws IllegalStateException, IOException {
        block12: {
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(this._containerFile.toFile(), "r");){
                if (_k2sWriting.equals(randomAccessFile.readUTF())) {
                    int containerVersion = randomAccessFile.readInt();
                    if (containerVersion == 1) {
                        Deserializer deserializer;
                        long headerOffset = randomAccessFile.readLong();
                        this._dataOffset = randomAccessFile.readLong();
                        randomAccessFile.seek(headerOffset);
                        long containerIdFile = randomAccessFile.readLong();
                        if (containerIdFile != this._containerId) {
                            _debug.error("Es wurde der falsche Container aus einer Datei eingelesen. Datei: " + String.valueOf(this._containerFile) + " erwartete ContainerId: " + this._containerId + " ContainerId in der Datei: " + containerIdFile);
                        }
                        assert (containerIdFile == this._containerId) : "Datei: " + String.valueOf(this._containerFile) + " erwartete ContainerId: " + this._containerId + " ContainerId in der Datei: " + containerIdFile;
                        this._dataCount = randomAccessFile.readInt();
                        this._deleteTime = randomAccessFile.readLong();
                        this._containerSize = randomAccessFile.length();
                        long dataTimeMax = randomAccessFile.readLong();
                        long archiveTimeMax = randomAccessFile.readLong();
                        long dataIndexMax = randomAccessFile.readLong();
                        this._maximumDataTiming = new DataTiming(dataTimeMax, archiveTimeMax, dataIndexMax);
                        long dataTimeMin = randomAccessFile.readLong();
                        long archiveTimeMin = randomAccessFile.readLong();
                        long dataIndexMin = randomAccessFile.readLong();
                        this._minimumDataTiming = new DataTiming(dataTimeMin, archiveTimeMin, dataIndexMin);
                        this._containerFinalized = randomAccessFile.readBoolean();
                        this._storeContainer = randomAccessFile.readBoolean();
                        this._labelTypeB = randomAccessFile.readInt();
                        this._serializerVersion = randomAccessFile.readInt();
                        int sizeOfArray = randomAccessFile.readInt();
                        byte[] byteArray = new byte[sizeOfArray];
                        randomAccessFile.readFully(byteArray);
                        ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
                        try {
                            deserializer = SerializingFactory.createDeserializer((int)2, (InputStream)in);
                        }
                        catch (NoSuchVersionException e) {
                            _debug.error("Der Header des Containers: " + this._containerId + " konnte nicht zur\u00fcckgelesen werden, da die Version des Serialisieres (Version 2) unbekannt war.", (Throwable)e);
                            throw new IOException(e);
                        }
                        long systemObject = deserializer.readLong();
                        long attributeGroup = deserializer.readLong();
                        long aspect = deserializer.readLong();
                        short simulationVariant = deserializer.readShort();
                        IdDataIdentification dataDescription = new IdDataIdentification(systemObject, attributeGroup, aspect, (int)simulationVariant);
                        ArchiveDataKind archiveDataKind = ArchiveDataKind.getInstance((int)deserializer.readInt());
                        this._dataContainerIdentification = dataDescription.resolve(archiveDataKind);
                        this._dataOffset = randomAccessFile.getFilePointer();
                        if (this._dataCount == 0) {
                            throw new IOException("Der Container mit der Id: " + this._containerId + " enth\u00e4lt keine Datens\u00e4tze, der Puffer konnte anscheinend vor Beendung des Archivsystems nicht gespeichert werden.");
                        }
                        break block12;
                    }
                    throw new IllegalStateException("Die Container-Version ist unbekannt, obwohl der Container mit einem K2S Modul erzeugt wurde. Containerpfad:" + String.valueOf(this._containerFile));
                }
                throw new IllegalStateException("Der angegebene Container ist nicht mit einem Modul der Firma K2S erzeugt worden und kann somit nicht eingelesen werden. Containerpfad: " + String.valueOf(this._containerFile));
            }
        }
    }

    public long getContainerId() {
        return this._containerId;
    }

    public IdContainerFileDir getContainerIdentification() {
        return this._dataContainerIdentification;
    }

    public DataContainerIdentification getDataContainerIdentification() {
        throw new UnsupportedOperationException();
    }

    public int getSerializerVersion() {
        return this._serializerVersion;
    }

    public void storeData(DataTiming dataTiming, DataState dataState, byte[] dataBytes, boolean flush) {
    }

    public void finalizeAllData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTiming getMinimumDataTiming() {
        Container container = this;
        synchronized (container) {
            return this._minimumDataTiming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTiming getMaximumDataTiming() {
        Container container = this;
        synchronized (container) {
            return this._maximumDataTiming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataCount() {
        Container container = this;
        synchronized (container) {
            return this._dataCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStorageSize() {
        Container container = this;
        synchronized (container) {
            return this._containerSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSaveStatus() {
        Container container = this;
        synchronized (container) {
            return this._storeContainer;
        }
    }

    public boolean containerSavedTypeB() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeleteDate() {
        Container container = this;
        synchronized (container) {
            return this._deleteTime;
        }
    }

    public int getVolumeIdTypeB() throws IllegalStateException {
        if (this._labelTypeB >= 0) {
            return this._labelTypeB;
        }
        throw new IllegalStateException("Der Container " + this._containerId + " wurde noch nicht der Sicherung \u00fcbergeben.");
    }

    public int saveAllData() {
        throw new UnsupportedOperationException();
    }

    public boolean deleteAllData() {
        throw new UnsupportedOperationException();
    }

    public void loadAllData(int mediaName) {
        throw new UnsupportedOperationException();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerFinalized() {
        Container container = this;
        synchronized (container) {
            return this._containerFinalized;
        }
    }

    private Path getContainerDirectory(long containerID, Path rootFolder) {
        long id = containerID;
        Path path = rootFolder;
        StringBuilder containerPath = new StringBuilder();
        for (int layer = 0; layer < 8; ++layer) {
            double containersPerDirectorylDouble = Math.pow(100.0, 8 - layer) * 1000.0 / 100.0;
            long containersThisLevel = (long)containersPerDirectorylDouble;
            long helpVariableDouble = id / containersThisLevel;
            long lowerIndex = helpVariableDouble * containersThisLevel;
            long upperIndex = (helpVariableDouble + 1L) * containersThisLevel - 1L;
            containerPath.append(lowerIndex);
            containerPath.append('-');
            containerPath.append(upperIndex);
            path = path.resolve(containerPath.toString());
            containerPath = new StringBuilder();
            id -= containersThisLevel * helpVariableDouble;
        }
        return path;
    }

    public ContainerDataSupplier getSupplier() throws IOException {
        return new ContainerDataSupplier();
    }

    public final class ContainerDataSupplier
    implements AutoCloseable {
        private final DataInputStream file;

        public ContainerDataSupplier() throws IOException {
            this.file = new DataInputStream(new BufferedInputStream(Files.newInputStream(Container.this._containerFile, new OpenOption[0])));
            this.file.skipNBytes(Container.this._dataOffset);
        }

        public PersistentData fetchNextData() throws IOException {
            PersistentData persistentData;
            try {
                long dataTime = this.file.readLong();
                long archiveTime = this.file.readLong();
                long dataIndex = this.file.readLong();
                if (dataTime == 0L && archiveTime == 0L && dataIndex == 0L) {
                    return null;
                }
                DataTiming dataTiming = new DataTiming(dataTime, archiveTime, dataIndex);
                DataState dataState = DataState.getInstance((int)this.file.readInt());
                ArchiveDataCompression archiveDataCompression = ArchiveDataCompression.getInstance((int)this.file.readByte());
                byte[] dataBytes = new byte[this.file.readInt()];
                if (dataState == DataState.DATA) {
                    if (dataBytes.length > 0) {
                        this.file.readFully(dataBytes);
                    } else {
                        dataBytes = null;
                    }
                } else {
                    dataBytes = null;
                }
                PersistentContainerData persistentContainerData = new PersistentContainerData(dataTiming, dataState, archiveDataCompression, dataBytes);
                persistentData = new PersistentData((PersistentDataContainer)Container.this, persistentContainerData);
            }
            catch (RuntimeException e) {
                _debug.error("Fehler beim Lesen des Containers \"" + String.valueOf(Container.this._containerFile) + "\". Der Rest des Containers wird \u00fcbersprungen", (Throwable)e);
                return null;
            }
            return persistentData;
        }

        @Override
        public void close() throws Exception {
            this.file.close();
        }
    }
}

