/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.backup;

import de.bsvrz.ars.ars.backup.BackupException;
import de.bsvrz.ars.ars.backup.BackupImplementation;
import de.bsvrz.ars.ars.backup.BackupModul;
import de.bsvrz.ars.ars.backup.Container;
import de.bsvrz.ars.ars.mgmt.tasks.AbstractTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class BackupAdapter
implements BackupImplementation {
    private final BackupModul _delegate;
    private final List<File> _tmpFiles = new ArrayList<File>();
    private final Path _tmpDir;

    protected BackupAdapter(BackupModul delegate) throws IOException {
        this._delegate = delegate;
        this._tmpDir = Files.createTempDirectory("backup", new FileAttribute[0]);
    }

    @Override
    public void openMediumBeforeBackup(int mediumID, String backupRunID) throws BackupException {
        this._delegate.openMediumBeforeBackup(mediumID, backupRunID);
    }

    @Override
    public boolean backupContainer(int mediumID, Container containerData) throws BackupException {
        if (!this._delegate.hasMediumCapacity(mediumID, containerData.getFileSize(), BackupImplementation.estimateIndexSize(this._tmpFiles.size() + 1))) {
            return false;
        }
        try {
            File tmp = this._tmpDir.resolve(containerData.getFileName()).toFile();
            containerData.backup(new FileOutputStream(tmp), mediumID);
            this._delegate.backupContainer(mediumID, containerData.getContainerId(), tmp);
            this._tmpFiles.add(tmp);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        return true;
    }

    @Override
    public void closeMediumAfterBackup(int mediumID, File indexFile) throws BackupException {
        this._delegate.closeMediumAfterBackup(mediumID, indexFile);
        this._tmpFiles.forEach(File::delete);
        this._tmpFiles.clear();
    }

    @Override
    public InputStream restoreContainer(int mediumID, String contFileName) throws BackupException {
        return this._delegate.restoreContainer(mediumID, contFileName);
    }

    @Override
    public List<String> getAllContFileNames(AbstractTask task, int mediumID) throws BackupException {
        return this._delegate.getAllContFileNames(task, mediumID, -1);
    }
}

