/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.backup.plugins;

import de.bsvrz.ars.ars.backup.BackupException;
import de.bsvrz.ars.ars.backup.BackupImplementation;
import de.bsvrz.ars.ars.backup.Container;
import de.bsvrz.ars.ars.backup.MediumNotAccessibleException;
import de.bsvrz.ars.ars.mgmt.tasks.AbstractTask;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractFileSystemBackup
implements BackupImplementation {
    public static final String PROP_BACKUP_DIR = "sicherungsVerzeichnis";
    public static final String PROP_BACKUP_CONTAINER_PER_ZIP = "containerPerZip";
    public static final String PROP_BACKUP_MEDIUMSIZE = "sicherungsMedienGroesseKB";
    protected int _maxContainersPerZip = 1000;
    protected long _maxMediumSizeKb = 0x433000L;
    protected final Debug logger = Debug.getLogger();
    protected long currentSpaceOccupiedByZipfiles;
    protected long currentSpaceOccupiedByContainers;
    protected String currentBackupPath;
    protected String backupBasePath;
    private int currentContIndex;
    private final List<Container> currentContainersToBeSaved = new ArrayList<Container>();

    public abstract boolean hasMediumCapacity(long var1, int var3);

    @Override
    public boolean backupContainer(int mediumID, Container contFile) throws BackupException {
        if (!this.hasMediumCapacity(contFile.getFileSize(), BackupImplementation.estimateIndexSize(this.currentContainersToBeSaved.size() + 1))) {
            return false;
        }
        try {
            if (++this.currentContIndex % this._maxContainersPerZip != 0) {
                this.currentContainersToBeSaved.add(contFile);
                this.currentSpaceOccupiedByContainers += contFile.getFileSize();
            } else {
                this.currentContainersToBeSaved.add(contFile);
                this.currentSpaceOccupiedByContainers += contFile.getFileSize();
                this.backupContainerList(mediumID);
            }
            return true;
        }
        catch (Exception e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void openMediumBeforeBackup(int mediumID, String backupRunID) {
        String tmpMediumPath = this.backupBasePath + File.separator + "Medium_" + mediumID;
        if (!new File(tmpMediumPath).exists()) {
            new File(tmpMediumPath).mkdir();
        }
        this.currentBackupPath = tmpMediumPath + File.separator + backupRunID;
        if (!new File(this.currentBackupPath).exists()) {
            new File(this.currentBackupPath).mkdir();
        }
    }

    @Override
    public void closeMediumAfterBackup(int mediumID, File indexFile) throws BackupException {
        try {
            if (!this.currentContainersToBeSaved.isEmpty()) {
                this.backupContainerList(mediumID);
            }
            File newIndexFile = new File(this.currentBackupPath, indexFile.getName());
            try (FileInputStream is = new FileInputStream(indexFile);
                 FileOutputStream os = new FileOutputStream(newIndexFile);){
                AbstractFileSystemBackup.copyStream(is, os);
            }
        }
        catch (Exception e) {
            throw new BackupException(e);
        }
        finally {
            this.currentContainersToBeSaved.clear();
            this.currentSpaceOccupiedByContainers = 0L;
            this.currentSpaceOccupiedByZipfiles = 0L;
        }
    }

    @Override
    public InputStream restoreContainer(int mediumID, String contFileName) throws BackupException {
        String backupPath = this.getBackupPath(mediumID);
        this.logger.fine("Suche nach Container " + contFileName + " im Verzeichnis: " + backupPath);
        long contID = ContainerFile.getContID((String)contFileName);
        File zipFile = null;
        try {
            List<File> backupRuns = Arrays.asList(Util.listDirectories((String)backupPath));
            Collections.sort(backupRuns);
            boolean containerFound = false;
            int i = backupRuns.size() - 1;
            String backupRun = "";
            block9: while (!containerFound && i >= 0) {
                File indexFile;
                if (!(indexFile = new File(backupPath + File.separator + (backupRun = backupRuns.get(i--).getName()), "index.dat")).exists()) {
                    this.logger.info("kein Index-File gefunden: " + indexFile.getAbsolutePath());
                    continue;
                }
                try (RandomAccessFile raf = new RandomAccessFile(indexFile, "r");){
                    String line;
                    while ((line = raf.readLine()) != null) {
                        if (!line.contains(contFileName)) continue;
                        containerFound = true;
                        continue block9;
                    }
                }
            }
            if (!containerFound) {
                this.logger.error("Container " + contFileName + " konnte nicht auf MediumId=" + mediumID + " gefunden werden.");
                throw new BackupException("Container " + contFileName + " konnte nicht auf MediumId=" + mediumID + " gefunden werden.");
            }
            File[] zipfiles = new File(backupPath, backupRun).listFiles(pathname -> pathname.getName().endsWith(".zip"));
            if (zipfiles != null) {
                for (i = 0; i < zipfiles.length; ++i) {
                    String name = zipfiles[i].getName();
                    String firstContainerNameAbb = name.substring(0, name.indexOf(45));
                    String lastContainerNameAbb = name.substring(name.indexOf(45) + 1, name.length() - 4);
                    long firstContID = Long.parseLong(firstContainerNameAbb.substring(2));
                    long lastContID = Long.parseLong(lastContainerNameAbb.substring(2));
                    if (contID < firstContID || contID > lastContID) continue;
                    zipFile = new File(backupPath + File.separator + backupRun, name);
                    break;
                }
            }
            if (zipFile == null) {
                this.logger.warning("Zip-Datei mit ContainerId=" + contID + " konnte nicht auf MediumID=" + mediumID + " gefunden werden.");
                throw new BackupException("Zip-Datei mit ContainerId=" + contID + " konnte nicht gefunden werden.");
            }
        }
        catch (Exception e) {
            this.logger.warning("Zip-Datei mit ContainerId=" + contID + " konnte nicht auf MediumID=" + mediumID + " gefunden werden.", (Object)e.getMessage());
            throw new BackupException("Zip-Datei mit ContainerId=" + contID + " konnte nicht auf MediumID=" + mediumID + " gefunden werden.", e);
        }
        try {
            return AbstractFileSystemBackup.detachFileFromZip(zipFile, contFileName);
        }
        catch (Exception e) {
            throw new BackupException(e);
        }
    }

    @NotNull
    public abstract String getBackupPath(int var1);

    @Override
    public List<String> getAllContFileNames(AbstractTask task, int mediumID) throws BackupException {
        String backupPath = this.backupBasePath + File.separator + "Medium_" + mediumID;
        File tmpBackupPathFile = new File(backupPath);
        if (!tmpBackupPathFile.exists()) {
            this.logger.error("BackupPath " + backupPath + " existiert nicht.");
            throw new MediumNotAccessibleException(mediumID);
        }
        ArrayList<String> result = new ArrayList<String>();
        List<File> backupRuns = Arrays.asList(Util.listDirectories((String)backupPath));
        Collections.sort(backupRuns);
        for (int i = backupRuns.size() - 1; i >= 0; --i) {
            task.suspendTaskIfNecessary();
            String backupRun = backupRuns.get(i).getName();
            File indexFile = new File(backupPath + File.separator + backupRun, "index.dat");
            if (!indexFile.exists()) continue;
            try (RandomAccessFile raf = new RandomAccessFile(indexFile.getAbsolutePath(), "r");){
                String line;
                while ((line = raf.readLine()) != null) {
                    result.add(line.substring(line.lastIndexOf(File.separator) + 1));
                }
                continue;
            }
            catch (Exception e) {
                Debug.getLogger().error("FileSystemBackup: Indexdatei " + indexFile.getAbsolutePath() + " konnte nicht gelesen werden.", (Object)e.getMessage());
            }
        }
        return result;
    }

    private static InputStream detachFileFromZip(File zipFile, String contFileName) throws BackupException {
        try {
            ZipEntry zen;
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
            while ((zen = zin.getNextEntry()) != null) {
                if (!zen.getName().equals(contFileName)) continue;
                return zin;
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        throw new BackupException("Fehler beim Wiederherstellen: Datei '" + contFileName + "' konnte nicht aus Zip-Datei '" + zipFile.getAbsolutePath() + "' extrahiert werden.");
    }

    private void backupContainerList(int mediumId) throws Exception {
        File backupDir = new File(this.currentBackupPath);
        this.currentContainersToBeSaved.sort(Comparator.comparingLong(Container::getContainerId));
        String nameFirst = this.currentContainersToBeSaved.get(0).getFileName();
        String nameLast = this.currentContainersToBeSaved.get(this.currentContainersToBeSaved.size() - 1).getFileName();
        Object containerZipName = nameFirst.substring(0, nameFirst.indexOf(46));
        containerZipName = (String)containerZipName + "-" + nameLast.substring(0, nameLast.indexOf(46));
        File zipFile = new File(backupDir, (String)containerZipName + ".zip");
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            for (Container file : this.currentContainersToBeSaved) {
                ZipEntry entry = new ZipEntry(file.getFileName());
                entry.setSize(file.getFileSize());
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                file.backup(out, mediumId);
                out.closeEntry();
            }
            out.finish();
        }
        this.currentSpaceOccupiedByZipfiles += zipFile.length();
        this.currentSpaceOccupiedByContainers = 0L;
        this.currentContainersToBeSaved.clear();
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public String toString() {
        return "FileSystem (" + this.backupBasePath + ")";
    }
}

