/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.migration.
 *
 * de.bsvrz.ars.migration is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.migration is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.migration.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.backup;

/**
 * Diese Klasse kapselt Exceptions, die in den Methoden eines BackupModuls auftreten können.
 *
 * @author beck et al. projects GmbH
 * @author Christian Wied
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class BackupException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Erstellt eine neue BackupException
	 *
	 * @param msg Nachricht
	 */
	public BackupException(String msg) {
		super(msg);
	}

	/**
	 * Erstellt eine neue BackupException
	 *
	 * @param cause Exception
	 */
	public BackupException(Throwable cause) {
		super(cause);
	}

	/**
	 * Erstellt eine neue BackupException
	 *
	 * @param message Nachricht
	 * @param cause   Exception
	 */
	public BackupException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Erstellt eine neue BackupException
	 */
	public BackupException() {
		super();
	}
}
