/*
 *
 * Copyright 2018-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.migration.
 *
 * de.bsvrz.ars.migration is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.migration is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.migration.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.backup;

import java.util.Properties;

/**
 * Diese Klasse dient als Interface für alle Backup-Module.
 * <p>
 * Eine implementierende Klasse wird über Reflection initialisiert und muss für das angegebene {@link Properties}-Objekt
 * mit der {@link #getInstance(Properties)}-Methode eine entsprechende Implementierung der eigentlichen Methoden bereitstellen.
 *
 * @author Kappich Systemberatung
 */
public interface BackupModule {

	/**
	 * Diese Methode dient dem Initialisieren des BackupModuls. Da die Plugins immer mit leerem Konstruktor initialisiert werden, werden mit dieser Methode die
	 * Plugin-spezifischen Einstellungen vorgenommen. Fehlt ein obligatorischer Property-Key, wird eine Exception geworfen.
	 *
	 * @param props Parametrierung des Backup-Moduls durch den Benutzer (Konfigurationsdatei)
	 * @return eine Implementierung von {@link BackupImplementation}, die die eigentlichen Backup-Methoden enthält.
	 */
	BackupImplementation getInstance(Properties props);

}
