/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.migration.
 *
 * de.bsvrz.ars.migration is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.migration is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.migration.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.migration;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

/**
 * Dummy-SyncKey-implementierung, die nicht wirklich lockt, da das bei der Migration nicht notwendig ist.
 */
public record MigrationKey(IdDataIdentification dataIdentification,
                           Consumer<MigrationKey> indexCloser) implements SyncKey<IdDataIdentification> {

	public MigrationKey(IdDataIdentification dataIdentification) {
		this(dataIdentification, (lock) -> {
		});
	}

	@Override
	public IdDataIdentification getElement() {
		return dataIdentification;
	}

	@Override
	public Thread getThread() {
		return Thread.currentThread();
	}

	@Override
	public void close() {
		indexCloser.accept(this);
	}

	@Override
	public boolean isValid() {
		return true;
	}

	@Override
	public BooleanSupplier notClosed() {
		return () -> true;
	}
}
