/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.dua.pufferlzzsnachfordern;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.inovat.dua.pufferlzzsnachfordern.Auftrag;
import de.inovat.dua.pufferlzzsnachfordern.AuftragsListe;
import de.inovat.dua.pufferlzzsnachfordern.VewDeLve255;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class PufferAbrufLzzsNachfordern
implements StandardApplication {
    private static final long WARTEZEIT_AUF_NAECHSTEN_AUFTRAG = 60000L;
    private static final long EINE_MINUTE_IN_MILLISEKUNDEN = 60000L;
    private static final long EINE_STUNDE_IN_MILLISEKUNDEN = 3600000L;
    private static Debug debug;
    private List<String> _listePidsLzzs = new ArrayList<String>();
    private final List<SystemObject> _listeLzzsSystemObjekte = new ArrayList<SystemObject>();
    private final List<String> _listePidsLzzsNichtVorhanden = new ArrayList<String>();
    private final Map<String, VewDeLve255> _mapVewDeLve255 = new HashMap<String, VewDeLve255>();
    private ClientDavInterface _dav;
    private DataModel _konfiguration;
    private String _listePidsLzzsAufrufParameter;
    Map<SystemObject, Set<SystemObject>> _mapDe255ZuFs;
    Map<SystemObject, SystemObject> _mapDeLveZuDe255;
    Map<SystemObject, SystemObject> _mapDeLveZuFs;
    private int _datenNachforderungInTagen;
    private String _datenNachforderungInTagenAufrufParameter;
    private int _minWarteZeitZwischenAbrufVersuchenInStunden;
    private String _minWarteZeitZwischenAbrufVersuchenInStundenAufrufParameter;
    private int _maxAnzahlAbrufVersuche;
    private String _maxAnzahlAbrufVersucheAufrufParameter;

    public static void main(String[] args) {
        PufferAbrufLzzsNachfordern pufferAbrufLzzsNachfordern = new PufferAbrufLzzsNachfordern();
        try {
            StandardApplicationRunner.run((StandardApplication)pufferAbrufLzzsNachfordern, (String[])args);
            debug = Debug.getLogger();
            pufferAbrufLzzsNachfordern.auswertungAufrufParameterListePids();
            pufferAbrufLzzsNachfordern.initialisierung();
            debug.config(pufferAbrufLzzsNachfordern.ausgabeKonfigurationsZusammenfassung());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            debug.error(String.format("%n=================================================================%nProgramm 'PufferAbruf Langzeitdaten nachfordern' wegen unerwartetem Fehler beendet...%n=================================================================%n", new Object[0]));
            System.exit(-1);
        }
        pufferAbrufLzzsNachfordern.run();
    }

    /*
     * WARNING - void declaration
     */
    private String ausgabeKonfigurationsZusammenfassung() {
        StringBuilder sb = new StringBuilder();
        this._listeLzzsSystemObjekte.sort(Comparator.comparing(SystemObject::getPid));
        this._listePidsLzzsNichtVorhanden.sort(String::compareTo);
        sb.append(System.lineSeparator() + "####################################################################################" + System.lineSeparator());
        sb.append("START: Konfigurationszusammenfassung f\u00fcr PufferAbrufLzzsNachfordern" + System.lineSeparator());
        sb.append("####################################################################################" + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Im Aufrufparameter angegebene PIDs, zu denen keine SystemObjekte existieren" + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        int i = 0;
        for (String string : this._listePidsLzzsNichtVorhanden) {
            sb.append(String.format("%04d: %s%n", ++i, string));
        }
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Liste der PIDs der verwendeten Systemobjekte" + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        int j = 0;
        for (SystemObject so : this._listeLzzsSystemObjekte) {
            sb.append(String.format("%04d: %s%n", ++j, so.getPidOrNameOrId()));
        }
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Liste der DeLve255 zum Pufferabruf und den zugeordneten Fahrstreifenobjekten" + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        boolean bl = false;
        for (SystemObject soDeLve255 : this._mapDe255ZuFs.keySet()) {
            void var4_8;
            sb.append(String.format("%04d: %s%n", (int)(++var4_8), soDeLve255.getPidOrNameOrId()));
            int l = 0;
            for (SystemObject soFs : this._mapDe255ZuFs.get(soDeLve255)) {
                sb.append(String.format("      %04d: %s%n", ++l, soFs.getPidOrNameOrId()));
            }
        }
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Aufrufparameter -datenNachforderungInTagen=..." + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append(String.format("Parameter beim Aufruf (Vorgabe)       : [%s]%n", this._datenNachforderungInTagenAufrufParameter));
        sb.append(String.format("Parameter nach Auswertung (Verwendung): [%s]%n", this._datenNachforderungInTagen));
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Aufrufparameter -minWarteZeitZwischenAbrufVersuchenInStunden=..." + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append(String.format("Parameter beim Aufruf (Vorgabe)       : [%s]%n", this._minWarteZeitZwischenAbrufVersuchenInStundenAufrufParameter));
        sb.append(String.format("Parameter nach Auswertung (Verwendung): [%s]%n", this._minWarteZeitZwischenAbrufVersuchenInStunden));
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Aufrufparameter -maxAnzahlAbrufVersuche=..." + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append(String.format("Parameter beim Aufruf (Vorgabe)       : [%s]%n", this._maxAnzahlAbrufVersucheAufrufParameter));
        sb.append(String.format("Parameter nach Auswertung (Verwendung): [%s]%n", this._maxAnzahlAbrufVersuche));
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append("Auftragsliste initial..." + System.lineSeparator());
        sb.append("====================================================================================" + System.lineSeparator());
        sb.append(AuftragsListe.getInstanz().ausgabeGesamtListe());
        sb.append(System.lineSeparator());
        sb.append("####################################################################################" + System.lineSeparator());
        sb.append("ENDE: Konfigurationszusammenfassung f\u00fcr PufferAbrufLzzsNachfordern" + System.lineSeparator());
        sb.append("####################################################################################" + System.lineSeparator());
        return sb.toString();
    }

    private void auswertungAufrufParameterListePids() {
        try {
            this._listePidsLzzs = Arrays.asList(this._listePidsLzzsAufrufParameter.split("(:|,|;)"));
            this._listePidsLzzs.stream().map(s -> this._konfiguration.getObject(s)).distinct().flatMap(o -> {
                if (o instanceof ConfigurationArea) {
                    return ((ConfigurationArea)o).getCurrentObjects().stream().filter(so -> so.isOfType("typ.langZeitZ\u00e4hlstelle"));
                }
                if (o instanceof SystemObject && o.isOfType("typ.langZeitZ\u00e4hlstelle")) {
                    return Stream.of(o);
                }
                return Stream.empty();
            }).distinct().forEach(this._listeLzzsSystemObjekte::add);
            List listeAlleLzzsSystemObjekte = this._konfiguration.getType("typ.langZeitZ\u00e4hlstelle").getElements();
            boolean isAlle = this._listePidsLzzs.size() == 1 && this._listePidsLzzs.get(0).equals("alle");
            for (SystemObject so : listeAlleLzzsSystemObjekte) {
                if (!isAlle && !this._listePidsLzzs.contains(so.getPid())) continue;
                this._listeLzzsSystemObjekte.add(so);
            }
            ArrayList<String> listePidsVerwendet = new ArrayList<String>();
            for (SystemObject so : this._listeLzzsSystemObjekte) {
                listePidsVerwendet.add(so.getPid());
            }
            for (String pid : this._listePidsLzzs) {
                if (listePidsVerwendet.contains(pid)) continue;
                this._listePidsLzzsNichtVorhanden.add(pid);
            }
        }
        catch (Exception e) {
            debug.error("Es konnten keine Objekte vom typ.langZeitZ\u00e4hlstelle ermittelt werden! Programm wird beendet.", (Throwable)e);
            throw new RuntimeException();
        }
        if (this._listeLzzsSystemObjekte.isEmpty()) {
            debug.error("Es konnten keine Objekte vom typ.langZeitZ\u00e4hlstelle ermittelt werden! Programm wird beendet.");
            throw new RuntimeException();
        }
    }

    private Map<SystemObject, Set<SystemObject>> ermittleZuordnungDe255ZuFs(Map<SystemObject, SystemObject> mapDeLveZuDe255, Map<SystemObject, SystemObject> mapDeLveZuFs) {
        HashMap<SystemObject, Set<SystemObject>> mapDe255ZuFs = new HashMap<SystemObject, Set<SystemObject>>();
        for (SystemObject soDe : mapDeLveZuFs.keySet()) {
            SystemObject soDeLve255 = mapDeLveZuDe255.get(soDe);
            HashSet<SystemObject> mengeFs = (HashSet<SystemObject>)mapDe255ZuFs.get(soDeLve255);
            if (mengeFs == null) {
                mengeFs = new HashSet<SystemObject>();
            }
            mengeFs.add(mapDeLveZuFs.get(soDe));
            mapDe255ZuFs.put(soDeLve255, mengeFs);
        }
        return mapDe255ZuFs;
    }

    private Map<SystemObject, SystemObject> ermittleZuordnungDeLveZuDe255() {
        HashMap<SystemObject, SystemObject> mapDeLveZuDe255 = new HashMap<SystemObject, SystemObject>();
        AttributeGroup atg = this._konfiguration.getAttributeGroup("atg.de");
        Aspect asp = this._konfiguration.getAspect("asp.eigenschaften");
        List listeSm = this._konfiguration.getType("typ.steuerModul").getElements();
        for (SystemObject soSm : listeSm) {
            Data[] daten;
            List listeEak = ((ConfigurationObject)soSm).getNonMutableSet("Eak").getElements();
            ArrayList listeAllerDeAmSm = new ArrayList();
            for (SystemObject soEak : listeEak) {
                List listeDe = ((ConfigurationObject)soEak).getNonMutableSet("De").getElements();
                listeAllerDeAmSm.addAll(listeDe);
            }
            this._konfiguration.getConfigurationData(listeAllerDeAmSm.toArray(new SystemObject[listeAllerDeAmSm.size()]), atg, asp);
            SystemObject soDeLve255 = null;
            for (SystemObject soDe : listeAllerDeAmSm) {
                daten = this._konfiguration.getConfigurationData(new SystemObject[]{soDe}, atg, asp);
                if (!soDe.isOfType("typ.deLve") || daten[0].getUnscaledValue("DEKanal").intValue() != 255) continue;
                soDeLve255 = soDe;
                break;
            }
            if (soDeLve255 == null) continue;
            for (SystemObject soDe : listeAllerDeAmSm) {
                daten = this._konfiguration.getConfigurationData(new SystemObject[]{soDe}, atg, asp);
                if (!soDe.isOfType("typ.deLve") || daten[0].getUnscaledValue("DEKanal").intValue() == 255) continue;
                mapDeLveZuDe255.put(soDe, soDeLve255);
            }
        }
        return mapDeLveZuDe255;
    }

    private Map<SystemObject, SystemObject> ermittleZuordnungDeZuFsAusLzzs(List<SystemObject> listeLzzsSystemObjekte) {
        HashMap<SystemObject, SystemObject> mapDeLveZuFs = new HashMap<SystemObject, SystemObject>();
        for (SystemObject lzzs : listeLzzsSystemObjekte) {
            NonMutableSet nonMutableSetGegenRichtung;
            SystemObject soDe;
            AttributeGroup atg = this._konfiguration.getAttributeGroup("atg.langZeitZ\u00e4hlstelle");
            Aspect asp = this._konfiguration.getAspect("asp.eigenschaften");
            Data[] daten = this._konfiguration.getConfigurationData(new SystemObject[]{lzzs}, atg, asp);
            SystemObject soAwqInRichtung = daten[0].getItem("InRichtung").getReferenceValue("Auswertequerschnitt").getSystemObject();
            SystemObject soAwqGegenRichtung = daten[0].getItem("GegenRichtung").getReferenceValue("Auswertequerschnitt").getSystemObject();
            atg = this._konfiguration.getAttributeGroup("atg.auswerteQuerschnitt");
            asp = this._konfiguration.getAspect("asp.eigenschaften");
            daten = this._konfiguration.getConfigurationData(new SystemObject[]{soAwqInRichtung}, atg, asp);
            SystemObject soMqInRichtung = daten[0].getReferenceValue("Messquerschnitt").getSystemObject();
            daten = this._konfiguration.getConfigurationData(new SystemObject[]{soAwqGegenRichtung}, atg, asp);
            SystemObject soMqGegenRichtung = daten[0].getReferenceValue("Messquerschnitt").getSystemObject();
            atg = this._konfiguration.getAttributeGroup("atg.fahrStreifen");
            asp = this._konfiguration.getAspect("asp.eigenschaften");
            NonMutableSet nonMutableSetInRichtung = ((ConfigurationObject)soMqInRichtung).getNonMutableSet("FahrStreifen");
            if (nonMutableSetInRichtung != null) {
                List listeSoFS = nonMutableSetInRichtung.getElements();
                for (SystemObject soFs : listeSoFS) {
                    daten = this._konfiguration.getConfigurationData(new SystemObject[]{soFs}, atg, asp);
                    soDe = daten[0].getReferenceValue("FahrStreifenQuelle").getSystemObject();
                    if (soDe == null) continue;
                    mapDeLveZuFs.put(soDe, soFs);
                }
            }
            if ((nonMutableSetGegenRichtung = ((ConfigurationObject)soMqGegenRichtung).getNonMutableSet("FahrStreifen")) == null) continue;
            List listeSoFS = nonMutableSetGegenRichtung.getElements();
            for (SystemObject soFs : listeSoFS) {
                daten = this._konfiguration.getConfigurationData(new SystemObject[]{soFs}, atg, asp);
                soDe = daten[0].getReferenceValue("FahrStreifenQuelle").getSystemObject();
                if (soDe == null) continue;
                mapDeLveZuFs.put(soDe, soFs);
            }
        }
        return mapDeLveZuFs;
    }

    private void erzeugeAuftraegeFuerNeueDatenLuecken() {
        AuftragsListe auftragsListe = AuftragsListe.getInstanz();
        for (VewDeLve255 vewDeLve255 : this._mapVewDeLve255.values()) {
            while (vewDeLve255.getLetzterIntervallBeginn() + 3600000L < System.currentTimeMillis() - (long)this._minWarteZeitZwischenAbrufVersuchenInStunden * 3600000L) {
                long ausfuehrungsZeitPunkt = auftragsListe.ermittleSpaetestenAusfuehrungsZeitPunkt(vewDeLve255) + 60000L;
                long intervallBeginn = vewDeLve255.getLetzterIntervallBeginn() + 3600000L;
                long intervallEnde = intervallBeginn + 3600000L;
                Auftrag auftrag = new Auftrag(ausfuehrungsZeitPunkt, intervallBeginn, intervallEnde, 1, vewDeLve255);
                auftragsListe.addAuftrag(auftrag);
                vewDeLve255.setLetzterIntervallBeginn(intervallBeginn);
                debug.info(String.format("Neuer erstmalig eingestellter Auftrag: %s", auftrag));
            }
        }
    }

    private void initialisierung() {
        this._mapDeLveZuDe255 = this.ermittleZuordnungDeLveZuDe255();
        this._mapDeLveZuFs = this.ermittleZuordnungDeZuFsAusLzzs(this._listeLzzsSystemObjekte);
        this._mapDe255ZuFs = this.ermittleZuordnungDe255ZuFs(this._mapDeLveZuDe255, this._mapDeLveZuFs);
        while (!this._dav.getArchive().isArchiveAvailable()) {
            try {
                debug.warning("Archiv ist nicht verf\u00fcgbar. Warte 1 Minute auf Verf\u00fcgbarkeit...");
                Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (InterruptedException e) {
                debug.error("Wartezeit auf Archivverf\u00fcgbarkeit unterbrochen", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        for (SystemObject deLve255 : this._mapDe255ZuFs.keySet()) {
            VewDeLve255 vewDeLve255 = new VewDeLve255(this._dav, deLve255, this._mapDe255ZuFs.get(deLve255), this._datenNachforderungInTagen, this._minWarteZeitZwischenAbrufVersuchenInStunden, this._maxAnzahlAbrufVersuche);
            this._mapVewDeLve255.put(deLve255.getPid(), vewDeLve255);
        }
    }

    public void initialize(ClientDavInterface dav) {
        this._dav = dav;
        this._konfiguration = this._dav.getDataModel();
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        debug = Debug.getLogger();
        this._listePidsLzzsAufrufParameter = argumentList.fetchArgument("-listePids=alle").asNonEmptyString();
        try {
            this._datenNachforderungInTagenAufrufParameter = argumentList.fetchArgument("-datenNachforderungInTagen=40").asNonEmptyString().trim();
            this._datenNachforderungInTagen = Integer.parseInt(this._datenNachforderungInTagenAufrufParameter);
            if (this._datenNachforderungInTagen < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this._datenNachforderungInTagen = 40;
            debug.warning(String.format("Aufrufparameter [-datenNachforderungInTagen=%s] ist ung\u00fcltig. Wert wurde f\u00fcr weitere Berechnung auf [-datenNachforderungInTagen=%d] gesetzt.", this._datenNachforderungInTagenAufrufParameter, this._datenNachforderungInTagen));
        }
        try {
            this._minWarteZeitZwischenAbrufVersuchenInStundenAufrufParameter = argumentList.fetchArgument("-minWarteZeitZwischenAbrufVersuchenInStunden=24").asNonEmptyString().trim();
            this._minWarteZeitZwischenAbrufVersuchenInStunden = Integer.parseInt(this._minWarteZeitZwischenAbrufVersuchenInStundenAufrufParameter);
            if (this._minWarteZeitZwischenAbrufVersuchenInStunden < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this._minWarteZeitZwischenAbrufVersuchenInStunden = 12;
            debug.warning(String.format("Aufrufparameter [-minWarteZeitZwischenAbrufVersuchenInStunden=%s] ist ung\u00fcltig. Wert wurde f\u00fcr weitere Berechnung auf [-minWarteZeitZwischenAbrufVersuchenInStunden=%d] gesetzt.", this._minWarteZeitZwischenAbrufVersuchenInStundenAufrufParameter, this._minWarteZeitZwischenAbrufVersuchenInStunden));
        }
        try {
            this._maxAnzahlAbrufVersucheAufrufParameter = argumentList.fetchArgument("-maxAnzahlAbrufVersuche=10").asNonEmptyString().trim();
            this._maxAnzahlAbrufVersuche = Integer.parseInt(this._maxAnzahlAbrufVersucheAufrufParameter);
            if (this._maxAnzahlAbrufVersuche < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this._maxAnzahlAbrufVersuche = 10;
            debug.warning(String.format("Aufrufparameter [-maxAnzahlAbrufVersuche=%s] ist ung\u00fcltig. Wert wurde f\u00fcr weitere Berechnung auf [-maxAnzahlAbrufVersuche=%d] gesetzt.", this._maxAnzahlAbrufVersucheAufrufParameter, this._maxAnzahlAbrufVersuche));
        }
    }

    private void run() {
        debug.info(String.format("%n=================================================================%nProgramm 'PufferAbruf Langzeitdaten nachfordern' gestartet...%n=================================================================%n", new Object[0]));
        AuftragsListe auftragsListe = AuftragsListe.getInstanz();
        long zeitPunktNeueDatenLueckenFuellen = System.currentTimeMillis() + 3600000L;
        while (true) {
            Auftrag auftrag;
            if ((auftrag = auftragsListe.holeNaechstenAuftrag()) != null) {
                auftrag.ausfuehren();
                continue;
            }
            debug.info(String.format("Zur Zeit keine sofort auszuf\u00fchrenden Auftr\u00e4ge in der Auftragsliste. Warte %d Sekunden.", 60L));
            try {
                Thread.sleep(60000L);
                if (System.currentTimeMillis() <= zeitPunktNeueDatenLueckenFuellen) continue;
                this.erzeugeAuftraegeFuerNeueDatenLuecken();
                continue;
            }
            catch (InterruptedException e) {
                debug.info("Sleep der Auftragsbearbeitung wurde vorzeitig unterbrochen: ", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

